/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDests;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilterList;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPageLabels;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFStructTreeRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFLinearization {
    private PDFDocument doc;
    private Map<PDFPage, Set<PDFObject>> pageObjsMap = new HashMap<PDFPage, Set<PDFObject>>();
    private PDFDictionary linearDict;
    private HintTable hintTable;

    public PDFLinearization(PDFDocument doc) {
        this.doc = doc;
    }

    private Set<PDFObject> assignNumbers() throws IOException {
        Set<PDFObject> page1Children = this.getPage1Children();
        if (!this.doc.pageObjs.isEmpty()) {
            for (int i = 1; i < this.doc.pageObjs.size(); ++i) {
                PDFPage page = this.doc.pageObjs.get(i);
                Set<PDFObject> children = this.pageObjsMap.get(page);
                for (PDFObject c : children) {
                    if (page1Children.contains(c) || !c.hasObjectNumber()) continue;
                    c.getObjectNumber().getNumber();
                }
            }
            for (PDFObject o : this.doc.objects) {
                if (o instanceof PDFDests || o instanceof PDFOutline) {
                    for (PDFObject c : this.getChildren(o)) {
                        c.getObjectNumber().getNumber();
                    }
                }
                if (!(o instanceof PDFInfo) && !(o instanceof PDFPageLabels)) continue;
                o.getObjectNumber().getNumber();
            }
            for (PDFObject o : this.doc.objects) {
                if (page1Children.contains(o)) continue;
                o.getObjectNumber().getNumber();
            }
        }
        this.linearDict = new LinearPDFDictionary(this.doc);
        for (PDFObject o : page1Children) {
            o.getObjectNumber().getNumber();
        }
        this.sort(this.doc.objects);
        return page1Children;
    }

    private void sort(List<PDFObject> objects) {
        Collections.sort(objects, new Comparator<PDFObject>(){

            @Override
            public int compare(PDFObject o1, PDFObject o2) {
                return Integer.valueOf(o1.getObjectNumber().getNumber()).compareTo(o2.getObjectNumber().getNumber());
            }
        });
    }

    private Set<PDFObject> getChildren(PDFObject o) {
        LinkedHashSet<PDFObject> children = new LinkedHashSet<PDFObject>();
        children.add(o);
        o.getChildren(children);
        return children;
    }

    public void outputPages(OutputStream stream) throws IOException {
        Collections.sort(this.doc.pageObjs, new Comparator<PDFPage>(){

            @Override
            public int compare(PDFPage o1, PDFPage o2) {
                return Integer.valueOf(o1.pageIndex).compareTo(o2.pageIndex);
            }
        });
        this.doc.objects.addAll(this.doc.trailerObjects);
        this.doc.trailerObjects = null;
        if (this.doc.getStructureTreeElements() != null) {
            this.doc.objects.addAll(this.doc.getStructureTreeElements());
            this.doc.structureTreeElements = null;
        }
        for (int i = 0; i < this.doc.objects.size() * 2; ++i) {
            this.doc.indirectObjectOffsets.add(0L);
        }
        Set<PDFObject> page1Children = this.assignNumbers();
        this.doc.streamIndirectObject(this.linearDict, new ByteArrayOutputStream());
        for (PDFObject o : page1Children) {
            this.doc.objects.remove(o);
        }
        int sizeOfRest = this.doc.objects.size();
        ByteArrayOutputStream fakeHeaderTrailerStream = new ByteArrayOutputStream();
        long topTrailer = this.doc.position;
        this.doc.writeTrailer(fakeHeaderTrailerStream, sizeOfRest, page1Children.size() + 1, page1Children.size() + sizeOfRest + 1, Long.MAX_VALUE, 0L);
        this.doc.position += (long)fakeHeaderTrailerStream.size();
        ByteArrayOutputStream pageStream = new ByteArrayOutputStream();
        this.writeObjects(page1Children, pageStream, sizeOfRest + 1);
        long trailerOffset = this.doc.position;
        ByteArrayOutputStream footerTrailerStream = new ByteArrayOutputStream();
        this.doc.writeTrailer(footerTrailerStream, 0, sizeOfRest, sizeOfRest, 0L, topTrailer);
        this.doc.position += (long)footerTrailerStream.size();
        this.linearDict.put("/L", this.doc.position);
        PDFDocument.outputIndirectObject(this.linearDict, stream);
        CountingOutputStream realTrailer = new CountingOutputStream(stream);
        this.doc.writeTrailer((OutputStream)realTrailer, sizeOfRest, page1Children.size() + 1, page1Children.size() + sizeOfRest + 1, trailerOffset, 0L);
        PDFLinearization.writePadding(fakeHeaderTrailerStream.size() - realTrailer.getCount(), stream);
        for (PDFObject o : page1Children) {
            PDFDocument.outputIndirectObject(o, stream);
            if (!(o instanceof HintTable)) continue;
            break;
        }
        stream.write(pageStream.toByteArray());
        stream.write(footerTrailerStream.toByteArray());
    }

    private Set<PDFObject> getPage1Children() throws IOException {
        LinkedHashSet<PDFObject> page1Children = new LinkedHashSet<PDFObject>();
        if (!this.doc.pageObjs.isEmpty()) {
            PDFPage page1 = this.doc.pageObjs.get(0);
            page1Children.add(this.doc.getRoot());
            this.hintTable = new HintTable(this.doc);
            page1Children.add(this.hintTable);
            page1Children.add(page1);
            page1.getChildren(page1Children);
            this.doc.objects.remove(this.doc.getPages());
            this.doc.objects.add(0, this.doc.getPages());
            this.pageObjsMap.put(page1, page1Children);
            for (int i = 1; i < this.doc.pageObjs.size(); ++i) {
                PDFPage page = this.doc.pageObjs.get(i);
                this.pageObjsMap.put(page, this.getChildren(page));
            }
        }
        return page1Children;
    }

    private static void writePadding(int padding, OutputStream stream) throws IOException {
        for (int i = 0; i < padding; ++i) {
            stream.write(" ".getBytes("UTF-8"));
        }
    }

    private void writeObjects(Set<PDFObject> children1, OutputStream pageStream, int sizeOfRest) throws IOException {
        this.writePage1(children1, pageStream);
        this.linearDict.put("/E", this.doc.position);
        for (PDFPage page : this.doc.pageObjs) {
            if (page.pageIndex == 0) continue;
            this.writePage(page, pageStream);
        }
        while (!this.doc.objects.isEmpty()) {
            PDFObject o = this.doc.objects.remove(0);
            if (o instanceof PDFOutline) {
                this.writeObjectGroup("/O", this.getChildren(o), pageStream);
                continue;
            }
            if (o instanceof PDFDests) {
                this.writeObjectGroup("/E", this.getChildren(o), pageStream);
                continue;
            }
            if (o instanceof PDFInfo) {
                this.writeObjectGroup("/I", this.getChildren(o), pageStream);
                continue;
            }
            if (o instanceof PDFPageLabels) {
                this.writeObjectGroup("/L", this.getChildren(o), pageStream);
                continue;
            }
            if (o instanceof PDFStructTreeRoot) {
                this.writeObjectGroup("/C", this.getChildren(o), pageStream);
                continue;
            }
            this.doc.streamIndirectObject(o, pageStream);
        }
        this.linearDict.put("/T", this.doc.position + 8L + (long)String.valueOf(sizeOfRest).length());
    }

    private void writeObjectGroup(String name, Set<PDFObject> objects, OutputStream pageStream) throws IOException {
        ArrayList<PDFObject> children = new ArrayList<PDFObject>(objects);
        this.sort(children);
        int[] values = this.hintTable.hintGroups.get(name);
        values[0] = ((PDFObject)children.iterator().next()).getObjectNumber().getNumber();
        values[1] = (int)this.doc.position;
        values[2] = children.size();
        for (PDFObject o : children) {
            values[3] = values[3] + this.doc.streamIndirectObject(o, pageStream);
            this.doc.objects.remove(o);
        }
    }

    private void writePage1(Set<PDFObject> children1, OutputStream pageStream) throws IOException {
        this.hintTable.pageStartPos = (int)this.doc.position;
        OutputStream stream = new ByteArrayOutputStream();
        Set<PDFObject> sharedChildren = this.getSharedObjects();
        int page1Len = 0;
        int objCount = 0;
        int sharedCount = 0;
        for (PDFObject o : children1) {
            if (o instanceof HintTable) {
                PDFArray a = (PDFArray)this.linearDict.get("/H");
                a.set(0, this.doc.position);
                this.doc.streamIndirectObject(o, stream);
                a.set(1, (double)this.doc.position - (Double)a.get(0));
                stream = pageStream;
                continue;
            }
            int len = this.doc.streamIndirectObject(o, stream);
            if (o instanceof PDFStream && this.hintTable.contentStreamLengths.get(0) == 0) {
                this.hintTable.contentStreamLengths.set(0, len);
            }
            if (!(o instanceof PDFRoot)) {
                page1Len += len;
                ++objCount;
            }
            if (!sharedChildren.contains(o)) continue;
            this.hintTable.sharedLengths.set(sharedCount, len);
            ++sharedCount;
        }
        this.hintTable.pageLengths.set(0, page1Len);
        this.hintTable.objCount.set(0, objCount);
    }

    private Set<PDFObject> getSharedObjects() {
        Set<PDFObject> pageSharedChildren = this.getChildren(this.doc.pageObjs.get(0));
        for (int i = 0; i < pageSharedChildren.size(); ++i) {
            this.hintTable.sharedLengths.add(0);
        }
        return pageSharedChildren;
    }

    private void writePage(PDFPage page, OutputStream pageStream) throws IOException {
        Set<PDFObject> children = this.pageObjsMap.get(page);
        int pageLen = 0;
        int objCount = 0;
        for (PDFObject c : children) {
            if (!this.doc.objects.contains(c)) continue;
            int len = this.doc.streamIndirectObject(c, pageStream);
            if (c instanceof PDFStream) {
                this.hintTable.contentStreamLengths.set(page.pageIndex, len);
            }
            pageLen += len;
            this.doc.objects.remove(c);
            ++objCount;
        }
        this.hintTable.pageLengths.set(page.pageIndex, pageLen);
        this.hintTable.objCount.set(page.pageIndex, objCount);
    }

    static class LinearPDFDictionary
    extends PDFDictionary {
        private int lastsize = -1;

        public LinearPDFDictionary(PDFDocument doc) {
            this.put("Linearized", 1);
            this.put("/L", 0);
            PDFArray larray = new PDFArray();
            larray.add(0.0);
            larray.add(0.0);
            this.put("/H", larray);
            doc.assignObjectNumber(this);
            this.getObjectNumber().getNumber();
            this.put("/O", this.getObjectNumber().getNumber() + 3);
            this.put("/E", 0);
            this.put("/N", doc.pageObjs.size());
            this.put("/T", 0);
        }

        public int output(OutputStream stream) throws IOException {
            int size = super.output(stream);
            int padding = this.lastsize - size + 32;
            if (this.lastsize == -1) {
                padding = 32;
                this.lastsize = size;
            }
            PDFLinearization.writePadding(padding, stream);
            return size + padding;
        }
    }

    static class HintTable
    extends PDFStream {
        private List<PDFPage> pages;
        int pageStartPos;
        List<Integer> sharedLengths = new ArrayList<Integer>();
        List<Integer> pageLengths = new ArrayList<Integer>();
        List<Integer> contentStreamLengths = new ArrayList<Integer>();
        List<Integer> objCount = new ArrayList<Integer>();
        Map<String, int[]> hintGroups = new HashMap<String, int[]>();

        public HintTable(PDFDocument doc) {
            super(false);
            doc.assignObjectNumber(this);
            doc.addObject(this);
            this.pages = doc.pageObjs;
            for (int i = 0; i < this.pages.size(); ++i) {
                this.pageLengths.add(0);
                this.contentStreamLengths.add(0);
                this.objCount.add(0);
            }
            this.hintGroups.put("/C", new int[4]);
            this.hintGroups.put("/L", new int[4]);
            this.hintGroups.put("/I", new int[4]);
            this.hintGroups.put("/E", new int[4]);
            this.hintGroups.put("/O", new int[4]);
            this.hintGroups.put("/V", new int[4]);
        }

        public PDFFilterList getFilterList() {
            return new PDFFilterList(this.getDocument().isEncryptionActive());
        }

        protected void outputRawStreamData(OutputStream os) throws IOException {
            CountingOutputStream bos = new CountingOutputStream(os);
            this.writeULong(1, (OutputStream)bos);
            this.writeULong(this.pageStartPos, (OutputStream)bos);
            this.writeCard16(32, (OutputStream)bos);
            this.writeULong(0, (OutputStream)bos);
            this.writeCard16(32, (OutputStream)bos);
            this.writeULong(0, (OutputStream)bos);
            this.writeCard16(0, (OutputStream)bos);
            this.writeULong(0, (OutputStream)bos);
            this.writeCard16(32, (OutputStream)bos);
            this.writeCard16(0, (OutputStream)bos);
            this.writeCard16(0, (OutputStream)bos);
            this.writeCard16(0, (OutputStream)bos);
            this.writeCard16(4, (OutputStream)bos);
            for (PDFPage pDFPage : this.pages) {
                this.writeULong(this.objCount.get(pDFPage.pageIndex) - 1, (OutputStream)bos);
            }
            for (PDFPage pDFPage : this.pages) {
                this.writeULong(this.pageLengths.get(pDFPage.pageIndex), (OutputStream)bos);
            }
            for (PDFPage pDFPage : this.pages) {
                this.writeULong(this.contentStreamLengths.get(pDFPage.pageIndex), (OutputStream)bos);
            }
            this.writeSharedTable(bos);
            for (Map.Entry entry : this.hintGroups.entrySet()) {
                this.put((String)entry.getKey(), bos.getCount());
                for (int i : (int[])entry.getValue()) {
                    this.writeULong(i, (OutputStream)bos);
                }
                if (!((String)entry.getKey()).equals("/C")) continue;
                this.writeULong(0, (OutputStream)bos);
                this.writeCard16(0, (OutputStream)bos);
            }
        }

        private void writeSharedTable(CountingOutputStream bos) throws IOException {
            this.put("/S", bos.getCount());
            this.writeULong(0, (OutputStream)bos);
            this.writeULong(0, (OutputStream)bos);
            this.writeULong(this.sharedLengths.size(), (OutputStream)bos);
            this.writeULong(this.sharedLengths.size(), (OutputStream)bos);
            this.writeCard16(0, (OutputStream)bos);
            this.writeULong(0, (OutputStream)bos);
            this.writeCard16(32, (OutputStream)bos);
            for (int i : this.sharedLengths) {
                this.writeULong(i, (OutputStream)bos);
            }
            this.writeULong(0, (OutputStream)bos);
        }

        private void writeCard16(int s, OutputStream bos) throws IOException {
            byte b1 = (byte)(s >> 8 & 0xFF);
            byte b2 = (byte)(s & 0xFF);
            bos.write(b1);
            bos.write(b2);
        }

        private void writeULong(int s, OutputStream bos) throws IOException {
            byte b1 = (byte)(s >> 24 & 0xFF);
            byte b2 = (byte)(s >> 16 & 0xFF);
            byte b3 = (byte)(s >> 8 & 0xFF);
            byte b4 = (byte)(s & 0xFF);
            bos.write(b1);
            bos.write(b2);
            bos.write(b3);
            bos.write(b4);
        }
    }
}

