/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.charset;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.string.StringHelper;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.SortedMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CharsetManager {
    private static final SortedMap<String, Charset> s_aAllCharsets = Charset.availableCharsets();
    private static final CharsetManager s_aInstance = new CharsetManager();

    private CharsetManager() {
    }

    @Nonnull
    public static Charset getCharsetFromName(@Nonnull String sCharsetName) {
        try {
            return Charset.forName(sCharsetName);
        }
        catch (IllegalCharsetNameException ex) {
            throw new IllegalArgumentException("Charset '" + sCharsetName + "' unsupported in Java", ex);
        }
        catch (UnsupportedCharsetException ex) {
            throw new IllegalArgumentException("Charset '" + sCharsetName + "' unsupported on this platform", ex);
        }
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedMap<String, Charset> getAllCharsets() {
        return s_aAllCharsets;
    }

    @Nonnull
    public static byte[] getAsBytes(@Nonnull String sText, @Nonnull Charset aCharset) {
        if (sText == null) {
            throw new NullPointerException("text");
        }
        if (aCharset == null) {
            throw new NullPointerException("charset");
        }
        if (!aCharset.canEncode()) {
            throw new IllegalArgumentException("Cannot encode to " + aCharset);
        }
        return sText.getBytes(aCharset);
    }

    @Nonnull
    public static byte[] getAsBytes(@Nonnull String sText, @Nonnull @Nonempty String sCharsetName) {
        if (sText == null) {
            throw new NullPointerException("text");
        }
        if (StringHelper.hasNoText(sCharsetName)) {
            throw new IllegalArgumentException("empty charset");
        }
        try {
            return sText.getBytes(sCharsetName);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Failed to get string bytes in charset '" + sCharsetName + "'", ex);
        }
    }

    @Nullable
    public static String getAsStringInOtherCharset(@Nullable String sText, @Nonnull String sCurrentCharset, @Nonnull String sNewCharset) {
        if (sCurrentCharset == null) {
            throw new NullPointerException("currentCharset");
        }
        if (sNewCharset == null) {
            throw new NullPointerException("newCharset");
        }
        if (sText == null || sCurrentCharset.equals(sNewCharset)) {
            return sText;
        }
        return CharsetManager.getAsString(CharsetManager.getAsBytes(sText, sCurrentCharset), sNewCharset);
    }

    @Nullable
    public static String getAsStringInOtherCharset(@Nullable String sText, @Nonnull Charset aCurrentCharset, @Nonnull Charset aNewCharset) {
        if (aCurrentCharset == null) {
            throw new NullPointerException("currentCharset");
        }
        if (aNewCharset == null) {
            throw new NullPointerException("newCharset");
        }
        if (sText == null || aCurrentCharset.equals(aNewCharset)) {
            return sText;
        }
        return CharsetManager.getAsString(CharsetManager.getAsBytes(sText, aCurrentCharset), aNewCharset);
    }

    @Nonnull
    public static String getAsString(@Nonnull byte[] aBuffer, @Nonnull String sCharsetName) {
        return CharsetManager.getAsString(aBuffer, 0, aBuffer.length, sCharsetName);
    }

    @Nonnull
    public static String getAsString(@Nonnull byte[] aBuffer, @Nonnegative int nOfs, @Nonnegative int nLength, @Nonnull String sCharsetName) {
        try {
            return new String(aBuffer, nOfs, nLength, sCharsetName);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Unknown charset '" + sCharsetName + "'", ex);
        }
    }

    @Nonnull
    public static String getAsString(@Nonnull byte[] aBuffer, @Nonnull Charset aCharset) {
        return CharsetManager.getAsString(aBuffer, 0, aBuffer.length, aCharset);
    }

    @Nonnull
    public static String getAsString(@Nonnull byte[] aBuffer, @Nonnegative int nOfs, @Nonnegative int nLength, @Nonnull Charset aCharset) {
        return new String(aBuffer, nOfs, nLength, aCharset);
    }

    @Nonnegative
    public static int getUTF8ByteCount(@Nullable String s) {
        return s == null ? 0 : CharsetManager.getUTF8ByteCount(s.toCharArray());
    }

    @Nonnegative
    public static int getUTF8ByteCount(@Nullable char[] aChars) {
        int nCount = 0;
        if (aChars != null) {
            for (char c : aChars) {
                nCount += CharsetManager.getUTF8ByteCount(c);
            }
        }
        return nCount;
    }

    @Nonnegative
    public static int getUTF8ByteCount(@Nonnegative int c) {
        if (c < 0 || c > 65535) {
            throw new IllegalArgumentException("Invalid parameter: " + c);
        }
        if (c == 0) {
            return 2;
        }
        if (c <= 127) {
            return 1;
        }
        if (c <= 2047) {
            return 2;
        }
        if (c <= 55295) {
            return 3;
        }
        return 0;
    }
}

