/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.list;

import com.phloc.commons.IHasSize;
import com.phloc.commons.annotations.MustImplementEqualsAndHashcode;
import com.phloc.commons.factory.FactoryNull;
import com.phloc.commons.factory.IFactory;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.ArrayList;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SafeArrayList<ELEMENTTYPE>
extends ArrayList<ELEMENTTYPE>
implements IHasSize {
    @MustImplementEqualsAndHashcode
    private final IFactory<ELEMENTTYPE> m_aFactory;

    public SafeArrayList() {
        this(FactoryNull.getInstance());
    }

    public SafeArrayList(@Nonnull IFactory<ELEMENTTYPE> aFactory) {
        if (aFactory == null) {
            throw new NullPointerException("If you use the constructor with an IFactory you have to provide anything other than null.");
        }
        this.m_aFactory = aFactory;
    }

    private void _ensureSize(@Nonnegative int nIndex) {
        while (this.size() <= nIndex) {
            this.add(this.m_aFactory.create());
        }
    }

    @Override
    public ELEMENTTYPE get(@Nonnegative int nIndex) {
        this._ensureSize(nIndex);
        return (ELEMENTTYPE)super.get(nIndex);
    }

    @Override
    public ELEMENTTYPE set(@Nonnegative int nIndex, @Nonnull ELEMENTTYPE aElement) {
        this._ensureSize(nIndex);
        return super.set(nIndex, aElement);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SafeArrayList rhs = (SafeArrayList)o;
        return this.m_aFactory.equals(rhs.m_aFactory);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aFactory).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("factory", this.m_aFactory).toString();
    }
}

