/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.list;

import com.phloc.commons.IHasSize;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.iterate.EmptyIterator;
import com.phloc.commons.collections.iterate.EmptyListIterator;
import com.phloc.commons.collections.iterate.SingleElementIterator;
import com.phloc.commons.collections.iterate.SingleElementListIterator;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SingleElementList<ELEMENTTYPE>
implements List<ELEMENTTYPE>,
IHasSize {
    private boolean m_bHasElement;
    private ELEMENTTYPE m_aElement;

    public SingleElementList() {
        this.m_bHasElement = false;
        this.m_aElement = null;
    }

    public SingleElementList(@Nullable ELEMENTTYPE aElement) {
        this.m_bHasElement = true;
        this.m_aElement = aElement;
    }

    @Override
    public boolean add(@Nullable ELEMENTTYPE aElement) {
        if (this.m_bHasElement) {
            throw new IllegalStateException("List already contains an element");
        }
        this.m_aElement = aElement;
        this.m_bHasElement = true;
        return true;
    }

    @Override
    public void add(@Nonnegative int nIndex, @Nullable ELEMENTTYPE aElement) {
        if (nIndex != 0) {
            throw new IllegalArgumentException("Only 1 elements is allowed: " + nIndex);
        }
        if (this.m_bHasElement) {
            throw new IllegalStateException("List already contains an element");
        }
        this.m_aElement = aElement;
        this.m_bHasElement = true;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends ELEMENTTYPE> aElements) {
        if (aElements.size() > 1) {
            throw new IllegalArgumentException("Cannot add lists with more than one element!");
        }
        if (this.m_bHasElement) {
            throw new IllegalStateException("List already contains an element");
        }
        Iterator<ELEMENTTYPE> i = aElements.iterator();
        return i.hasNext() && this.add(i.next());
    }

    @Override
    public boolean addAll(@Nonnegative int nIndex, @Nonnull Collection<? extends ELEMENTTYPE> aElements) {
        if (nIndex != 0) {
            throw new IndexOutOfBoundsException("Only index 0 is valid!");
        }
        return this.addAll(aElements);
    }

    @Override
    public void clear() {
        this.m_aElement = null;
        this.m_bHasElement = false;
    }

    @Override
    public boolean contains(@Nullable Object aElement) {
        return this.m_bHasElement ? EqualsUtils.equals(this.m_aElement, aElement) : false;
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> aElements) {
        for (Object aElement : aElements) {
            if (this.contains(aElement)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ELEMENTTYPE get(@Nonnegative int nIndex) {
        if (!this.m_bHasElement || nIndex != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.m_aElement;
    }

    @Override
    public int indexOf(Object aElement) {
        return this.contains(aElement) ? 0 : -1;
    }

    @Override
    public boolean isEmpty() {
        return !this.m_bHasElement;
    }

    @Override
    @Nonnull
    public Iterator<ELEMENTTYPE> iterator() {
        return this.m_bHasElement ? SingleElementIterator.create(this.m_aElement) : EmptyIterator.getInstance();
    }

    @Override
    public int lastIndexOf(@Nullable Object aElement) {
        return this.contains(aElement) ? 0 : -1;
    }

    @Override
    @Nonnull
    public ListIterator<ELEMENTTYPE> listIterator() {
        return this.m_bHasElement ? SingleElementListIterator.create(this.m_aElement) : EmptyListIterator.getInstance();
    }

    @Override
    @Nonnull
    public ListIterator<ELEMENTTYPE> listIterator(int nIndex) {
        if (!this.m_bHasElement || nIndex != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.listIterator();
    }

    @Override
    @Nullable
    public ELEMENTTYPE remove(int nIndex) {
        if (!this.m_bHasElement || nIndex != 0) {
            throw new IndexOutOfBoundsException();
        }
        ELEMENTTYPE aElement = this.m_aElement;
        this.m_aElement = null;
        this.m_bHasElement = false;
        return aElement;
    }

    @Override
    public boolean remove(Object aElement) {
        if (!this.contains(aElement)) {
            return false;
        }
        this.m_aElement = null;
        this.m_bHasElement = false;
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> aElements) {
        boolean bRemovedAll = true;
        for (Object aElement : aElements) {
            if (this.remove(aElement)) continue;
            bRemovedAll = false;
        }
        return bRemovedAll;
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> aElements) {
        if (this.m_bHasElement) {
            if (aElements.contains(this.m_aElement)) {
                return true;
            }
            this.clear();
        }
        return false;
    }

    @Override
    @Nullable
    public ELEMENTTYPE set(@Nonnegative int nIndex, @Nullable ELEMENTTYPE aNewElement) {
        if (nIndex != 0) {
            throw new IllegalArgumentException("The passed index can onyl be 0!");
        }
        ELEMENTTYPE aOldElement = this.m_aElement;
        this.m_bHasElement = true;
        this.m_aElement = aNewElement;
        return aOldElement;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_bHasElement ? 1 : 0;
    }

    @Override
    @Nonnull
    public List<ELEMENTTYPE> subList(int nFromIndex, int nToIndex) {
        if (!this.m_bHasElement || nFromIndex != 0 || nToIndex != 0) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<ELEMENTTYPE> ret = new ArrayList<ELEMENTTYPE>();
        if (this.m_bHasElement) {
            ret.add(this.m_aElement);
        }
        return ret;
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        if (this.m_bHasElement) {
            Object[] aObjects = new Object[]{this.m_aElement};
            return aObjects;
        }
        return new Object[0];
    }

    @Override
    @Nonnull
    public <ARRAYELEMENTTYPE> ARRAYELEMENTTYPE[] toArray(@Nonnull ARRAYELEMENTTYPE[] aDest) {
        if (aDest == null) {
            throw new NullPointerException("destinationArray");
        }
        if (!this.m_bHasElement) {
            return aDest;
        }
        if (this.m_aElement != null && !aDest.getClass().getComponentType().isAssignableFrom(this.m_aElement.getClass())) {
            throw new ArrayStoreException("The array class " + aDest.getClass() + " cannot store the item of class " + this.m_aElement.getClass());
        }
        ARRAYELEMENTTYPE[] ret = aDest.length < 1 ? ArrayHelper.newArraySameType(aDest, 1) : aDest;
        ret[0] = GenericReflection.uncheckedCast(this.m_aElement);
        if (ret.length > 1) {
            ret[1] = null;
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        SingleElementList rhs = (SingleElementList)o;
        return this.m_bHasElement == rhs.m_bHasElement && EqualsUtils.equals(this.m_aElement, rhs.m_aElement);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_bHasElement).append(this.m_aElement).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("hasElement", this.m_bHasElement).append("element", this.m_aElement).toString();
    }

    @Nonnull
    public static <ELEMENTTYPE> SingleElementList<ELEMENTTYPE> create(@Nullable ELEMENTTYPE aElement) {
        return new SingleElementList<ELEMENTTYPE>(aElement);
    }
}

