/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.multimap;

import com.phloc.commons.collections.multimap.IMultiMap;
import com.phloc.commons.collections.multimap.MultiMapHelper;
import com.phloc.commons.state.EChange;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractMultiConcurrentHashMap<KEYTYPE, VALUETYPE, COLLTYPE extends Collection<VALUETYPE>>
extends ConcurrentHashMap<KEYTYPE, COLLTYPE>
implements IMultiMap<KEYTYPE, VALUETYPE, COLLTYPE> {
    public AbstractMultiConcurrentHashMap() {
    }

    public AbstractMultiConcurrentHashMap(@Nonnull KEYTYPE aKey, @Nullable VALUETYPE aValue) {
        this.putSingle(aKey, aValue);
    }

    public AbstractMultiConcurrentHashMap(@Nonnull KEYTYPE aKey, @Nonnull COLLTYPE aCollection) {
        this.put(aKey, aCollection);
    }

    public AbstractMultiConcurrentHashMap(@Nullable Map<? extends KEYTYPE, ? extends COLLTYPE> aCont) {
        if (aCont != null) {
            this.putAll(aCont);
        }
    }

    @Nonnull
    protected abstract COLLTYPE createNewCollection();

    @Override
    @Nonnull
    public final EChange putSingle(@Nonnull KEYTYPE aKey, @Nullable VALUETYPE aValue) {
        Collection<Object> aCont = (Collection)this.get(aKey);
        if (aCont == null) {
            aCont = this.createNewCollection();
            super.put(aKey, aCont);
        }
        return EChange.valueOf(aCont.add(aValue));
    }

    @Override
    @Nonnull
    public final EChange putAllIn(@Nonnull Map<? extends KEYTYPE, ? extends VALUETYPE> aMap) {
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry<KEYTYPE, VALUETYPE> aEntry : aMap.entrySet()) {
            eChange = eChange.or(this.putSingle(aEntry.getKey(), aEntry.getValue()));
        }
        return eChange;
    }

    @Override
    @Nonnull
    public final EChange removeSingle(@Nonnull KEYTYPE aKey, @Nullable VALUETYPE aValue) {
        Collection aCont = (Collection)this.get(aKey);
        return aCont == null ? EChange.UNCHANGED : EChange.valueOf(aCont.remove(aValue));
    }

    @Override
    public final boolean containsSingle(@Nonnull KEYTYPE aKey, @Nullable VALUETYPE aValue) {
        Collection aCont = (Collection)this.get(aKey);
        return aCont == null ? false : aCont.contains(aValue);
    }

    @Override
    @Nonnegative
    public final long getTotalValueCount() {
        return MultiMapHelper.getTotalValueCount(this);
    }
}

