/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.compare;

import com.phloc.commons.compare.AbstractComparator;
import com.phloc.commons.compare.CompareUtils;
import com.phloc.commons.compare.ESortOrder;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ComparatorUtils {
    private static final ComparatorUtils s_aInstance = new ComparatorUtils();

    private ComparatorUtils() {
    }

    @Nonnull
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> Comparator<? super Map.Entry<KEYTYPE, VALUETYPE>> getComparatorMapEntryKey() {
        return ComparatorUtils.getComparatorMapEntryKey(ESortOrder.DEFAULT);
    }

    @Nonnull
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> Comparator<? super Map.Entry<KEYTYPE, VALUETYPE>> getComparatorMapEntryKey(@Nonnull ESortOrder eSortOrder) {
        return new AbstractComparator<Map.Entry<KEYTYPE, VALUETYPE>>(eSortOrder){

            @Override
            protected int mainCompare(Map.Entry<KEYTYPE, VALUETYPE> aEntry1, Map.Entry<KEYTYPE, VALUETYPE> aEntry2) {
                return CompareUtils.nullSafeCompare((Comparable)aEntry1.getKey(), (Comparable)aEntry2.getKey());
            }
        };
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> Comparator<? super Map.Entry<KEYTYPE, VALUETYPE>> getComparatorMapEntryKey(final Comparator<? super KEYTYPE> aKeyComparator) {
        return new Comparator<Map.Entry<KEYTYPE, VALUETYPE>>(){

            @Override
            public int compare(Map.Entry<KEYTYPE, VALUETYPE> aEntry1, Map.Entry<KEYTYPE, VALUETYPE> aEntry2) {
                return aKeyComparator.compare(aEntry1.getKey(), aEntry2.getKey());
            }
        };
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE extends Comparable<? super VALUETYPE>> Comparator<? super Map.Entry<KEYTYPE, VALUETYPE>> getComparatorMapEntryValue() {
        return ComparatorUtils.getComparatorMapEntryValue(ESortOrder.DEFAULT);
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE extends Comparable<? super VALUETYPE>> Comparator<? super Map.Entry<KEYTYPE, VALUETYPE>> getComparatorMapEntryValue(@Nonnull ESortOrder eSortOrder) {
        return new AbstractComparator<Map.Entry<KEYTYPE, VALUETYPE>>(eSortOrder){

            @Override
            protected int mainCompare(Map.Entry<KEYTYPE, VALUETYPE> aEntry1, Map.Entry<KEYTYPE, VALUETYPE> aEntry2) {
                return CompareUtils.nullSafeCompare((Comparable)aEntry1.getValue(), (Comparable)aEntry2.getValue());
            }
        };
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> Comparator<? super Map.Entry<KEYTYPE, VALUETYPE>> getComparatorMapEntryValue(final @Nonnull Comparator<? super VALUETYPE> aValueComparator) {
        return new Comparator<Map.Entry<KEYTYPE, VALUETYPE>>(){

            @Override
            public int compare(Map.Entry<KEYTYPE, VALUETYPE> aEntry1, Map.Entry<KEYTYPE, VALUETYPE> aEntry2) {
                return aValueComparator.compare(aEntry1.getValue(), aEntry2.getValue());
            }
        };
    }
}

