/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.email;

import com.phloc.commons.regex.RegExPool;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class EmailAddressUtils {
    public static final String EMAIL_ADDRESS_PATTERN = "[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?";
    private static final Pattern s_aPattern = RegExPool.getPattern("[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?");

    private EmailAddressUtils() {
    }

    @Nullable
    public static String getUnifiedEmailAddress(@Nullable String sEmailAddress) {
        return sEmailAddress == null ? null : sEmailAddress.trim().toLowerCase(Locale.US);
    }

    public static boolean isValid(@Nullable String sEmailAddress) {
        if (sEmailAddress == null) {
            return false;
        }
        String sUnifiedEmail = EmailAddressUtils.getUnifiedEmailAddress(sEmailAddress);
        return s_aPattern.matcher(sUnifiedEmail).matches();
    }
}

