/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.error;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.error.IResourceLocation;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.name.IHasDisplayText;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.text.impl.ConstantTextProvider;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ResourceError
implements IResourceError {
    private final IResourceLocation m_aLocation;
    private final EErrorLevel m_eErrorLevel;
    private final IHasDisplayText m_aErrorText;
    private final Throwable m_aLinkedException;

    public ResourceError(@Nonnull IResourceLocation aLocation, @Nonnull EErrorLevel eErrorLevel, @Nonnull String sErrorText) {
        this(aLocation, eErrorLevel, sErrorText, null);
    }

    public ResourceError(@Nonnull IResourceLocation aLocation, @Nonnull EErrorLevel eErrorLevel, @Nonnull String sErrorText, @Nullable Throwable aLinkedException) {
        this(aLocation, eErrorLevel, new ConstantTextProvider(sErrorText), aLinkedException);
    }

    public ResourceError(@Nonnull IResourceLocation aLocation, @Nonnull EErrorLevel eErrorLevel, @Nonnull IHasDisplayText aErrorText) {
        this(aLocation, eErrorLevel, aErrorText, null);
    }

    public ResourceError(@Nonnull IResourceLocation aLocation, @Nonnull EErrorLevel eErrorLevel, @Nonnull IHasDisplayText aErrorText, @Nullable Throwable aLinkedException) {
        if (aLocation == null) {
            throw new NullPointerException("location");
        }
        if (eErrorLevel == null) {
            throw new NullPointerException("errorLevel");
        }
        if (aErrorText == null) {
            throw new NullPointerException("errorText");
        }
        this.m_aLocation = aLocation;
        this.m_eErrorLevel = eErrorLevel;
        this.m_aErrorText = aErrorText;
        this.m_aLinkedException = aLinkedException;
    }

    @Override
    @Nonnull
    public final IResourceLocation getLocation() {
        return this.m_aLocation;
    }

    @Override
    @Nonnull
    public final EErrorLevel getErrorLevel() {
        return this.m_eErrorLevel;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public String getDisplayText(@Nonnull Locale aContentLocale) {
        return this.m_aErrorText.getDisplayText(aContentLocale);
    }

    @Override
    @Nullable
    public final Throwable getLinkedException() {
        return this.m_aLinkedException;
    }

    @Override
    @Nonnull
    @OverrideOnDemand
    public String getAsString(@Nonnull Locale aDisplayLocale) {
        String ret = "[" + this.m_eErrorLevel.getID() + "]";
        String sLocation = this.m_aLocation.getAsString();
        if (StringHelper.hasText(sLocation)) {
            ret = ret + ' ' + sLocation + ": ";
        }
        ret = ret + this.getDisplayText(aDisplayLocale);
        if (this.m_aLinkedException != null) {
            ret = ret + " (" + this.m_aLinkedException.getMessage() + ")";
        }
        return ret;
    }

    @Override
    public final boolean isSuccess() {
        return this.m_eErrorLevel.isSuccess();
    }

    @Override
    public final boolean isFailure() {
        return this.m_eErrorLevel.isFailure();
    }

    @Override
    public final boolean isError() {
        return this.m_eErrorLevel.isError();
    }

    @Override
    public final boolean isNoError() {
        return this.m_eErrorLevel.isNoError();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ResourceError rhs = (ResourceError)o;
        return this.m_aLocation.equals(rhs.m_aLocation) && this.m_eErrorLevel.equals(rhs.m_eErrorLevel) && this.m_aErrorText.equals(rhs.m_aErrorText);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aLocation).append((Enum)this.m_eErrorLevel)).append(this.m_aErrorText).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("location", this.m_aLocation).append("errorLevel", this.m_eErrorLevel).append("errorText", this.m_aErrorText).appendIfNotNull("linkedException", this.m_aLinkedException).toString();
    }
}

