/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.format.impl;

import com.phloc.commons.format.IFormatter;
import com.phloc.commons.format.impl.AbstractStringFormatter;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public final class MinLengthAddLeadingFormatter
extends AbstractStringFormatter {
    private final int m_nMinLength;
    private final char m_cFill;

    public MinLengthAddLeadingFormatter(@Nonnegative int nMinLength, char cFill) {
        this(nMinLength, cFill, null);
    }

    public MinLengthAddLeadingFormatter(@Nonnegative int nMinLength, char cFill, @Nullable IFormatter aNestedFormatter) {
        super(aNestedFormatter);
        if (nMinLength < 1) {
            throw new IllegalArgumentException("Passed min length is too small: " + nMinLength);
        }
        this.m_nMinLength = nMinLength;
        this.m_cFill = cFill;
    }

    @Override
    protected String getFormattedValueAsString(@Nullable Object aValue) {
        String s = this.getValueAsString(aValue);
        if (s.length() >= this.m_nMinLength) {
            return s;
        }
        return StringHelper.getRepeated(this.m_cFill, this.m_nMinLength - s.length()) + s;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinLengthAddLeadingFormatter)) {
            return false;
        }
        MinLengthAddLeadingFormatter rhs = (MinLengthAddLeadingFormatter)o;
        return this.m_nMinLength == rhs.m_nMinLength && this.m_cFill == rhs.m_cFill;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nMinLength).append(this.m_cFill).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("minLength", this.m_nMinLength).append("fill", this.m_cFill).toString();
    }
}

