/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.idfactory;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.idfactory.IIntIDFactory;
import com.phloc.commons.idfactory.IStringIDFactory;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;

public class StringIDFromIntIDFactory
implements IStringIDFactory {
    private final IIntIDFactory m_aIntIDFactory;
    private final String m_sPrefix;

    public StringIDFromIntIDFactory(@Nonnull IIntIDFactory aIntIDFactory) {
        this(aIntIDFactory, "id");
    }

    public StringIDFromIntIDFactory(@Nonnull IIntIDFactory aIntIDFactory, @Nonnull String sPrefix) {
        if (aIntIDFactory == null) {
            throw new NullPointerException("intIDFactory");
        }
        if (sPrefix == null) {
            throw new NullPointerException("prefix");
        }
        this.m_aIntIDFactory = aIntIDFactory;
        this.m_sPrefix = sPrefix;
    }

    @Nonnull
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    @Nonnull
    public String getNewID() {
        return this.m_sPrefix + Integer.toString(this.m_aIntIDFactory.getNewID());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringIDFromIntIDFactory)) {
            return false;
        }
        StringIDFromIntIDFactory rhs = (StringIDFromIntIDFactory)o;
        return this.m_aIntIDFactory.equals(rhs.m_aIntIDFactory) && this.m_sPrefix.equals(rhs.m_sPrefix);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aIntIDFactory).append(this.m_sPrefix).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("intIDFactory", this.m_aIntIDFactory).append("prefix", this.m_sPrefix).toString();
    }
}

