/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.idfactory;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.idfactory.ILongIDFactory;
import com.phloc.commons.idfactory.IStringIDFactory;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;

public final class StringIDFromLongIDFactory
implements IStringIDFactory {
    private final ILongIDFactory m_aLongIDFactory;
    private final String m_sPrefix;

    public StringIDFromLongIDFactory(@Nonnull ILongIDFactory aLongIDFactory) {
        this(aLongIDFactory, "id");
    }

    public StringIDFromLongIDFactory(@Nonnull ILongIDFactory aLongIDFactory, @Nonnull String sPrefix) {
        if (aLongIDFactory == null) {
            throw new NullPointerException("longIDFactory");
        }
        if (sPrefix == null) {
            throw new NullPointerException("prefix");
        }
        this.m_aLongIDFactory = aLongIDFactory;
        this.m_sPrefix = sPrefix;
    }

    @Nonnull
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    @Nonnull
    public String getNewID() {
        return this.m_sPrefix + Long.toString(this.m_aLongIDFactory.getNewID());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringIDFromLongIDFactory)) {
            return false;
        }
        StringIDFromLongIDFactory rhs = (StringIDFromLongIDFactory)o;
        return this.m_aLongIDFactory.equals(rhs.m_aLongIDFactory) && this.m_sPrefix.equals(rhs.m_sPrefix);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aLongIDFactory).append(this.m_sPrefix).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("longIDFactory", this.m_aLongIDFactory).append("prefix", this.m_sPrefix).toString();
    }
}

