/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file;

import com.phloc.commons.io.file.EFileIOOperation;
import com.phloc.commons.io.file.FileIOError;
import com.phloc.commons.io.file.FileOperations;
import com.phloc.commons.io.file.IFileOperationCallback;
import com.phloc.commons.io.file.IFileOperationManager;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileOperationManager
implements IFileOperationManager {
    private FileIOError m_aLastError;
    private final IFileOperationCallback m_aCallback;

    public FileOperationManager() {
        this(null);
    }

    public FileOperationManager(@Nullable IFileOperationCallback aCallback) {
        this.m_aCallback = aCallback;
    }

    @Override
    @Nullable
    public FileIOError getLastError() {
        return this.m_aLastError;
    }

    @Override
    @Nullable
    public EFileIOOperation getLastOperation() {
        return this.m_aLastError == null ? null : this.m_aLastError.getOperation();
    }

    private void _handleLastError(@Nonnull FileIOError aLastError) {
        if (this.m_aCallback != null) {
            if (aLastError.isSuccess()) {
                this.m_aCallback.onSuccess(aLastError.getOperation(), aLastError.getFile1(), aLastError.getFile2());
            } else {
                this.m_aCallback.onError(aLastError.getOperation(), aLastError.getErrorCode(), aLastError.getFile1(), aLastError.getFile2(), aLastError.getException());
            }
        }
    }

    @Override
    @Nonnull
    public FileIOError createDir(@Nonnull File aDir) {
        this.m_aLastError = FileOperations.createDir(aDir);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError createDirIfNotExisting(@Nonnull File aDir) {
        this.m_aLastError = FileOperations.createDirIfNotExisting(aDir);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError createDirRecursive(@Nonnull File aDir) {
        this.m_aLastError = FileOperations.createDirRecursive(aDir);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError createDirRecursiveIfNotExisting(@Nonnull File aDir) {
        this.m_aLastError = FileOperations.createDirRecursiveIfNotExisting(aDir);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteDir(@Nonnull File aDir) {
        this.m_aLastError = FileOperations.deleteDir(aDir);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteDirIfExisting(@Nonnull File aDir) {
        this.m_aLastError = FileOperations.deleteDirIfExisting(aDir);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteDirRecursive(@Nonnull File aDir) {
        this.m_aLastError = FileOperations.deleteDirRecursive(aDir);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteDirRecursiveIfExisting(@Nonnull File aDir) {
        this.m_aLastError = FileOperations.deleteDirRecursiveIfExisting(aDir);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteFile(@Nonnull File aFile) {
        this.m_aLastError = FileOperations.deleteFile(aFile);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteFileIfExisting(@Nonnull File aFile) {
        this.m_aLastError = FileOperations.deleteFileIfExisting(aFile);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError renameDir(@Nonnull File aSourceDir, @Nonnull File aTargetDir) {
        this.m_aLastError = FileOperations.renameDir(aSourceDir, aTargetDir);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError renameFile(@Nonnull File aSourceFile, @Nonnull File aTargetFile) {
        this.m_aLastError = FileOperations.renameFile(aSourceFile, aTargetFile);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError copyDirRecursive(@Nonnull File aSourceDir, @Nonnull File aTargetDir) {
        this.m_aLastError = FileOperations.copyDirRecursive(aSourceDir, aTargetDir);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError copyFile(@Nonnull File aSourceFile, @Nonnull File aTargetFile) {
        this.m_aLastError = FileOperations.copyFile(aSourceFile, aTargetFile);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    public String toString() {
        return new ToStringGenerator(this).append("lastError", this.m_aLastError).append("callback", this.m_aCallback).toString();
    }
}

