/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.filter;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.file.filter.AbstractFileFilter;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FileFilterDirectoryFromFilenameFilter
extends AbstractFileFilter {
    private final FilenameFilter m_aFilenameFilter;

    public FileFilterDirectoryFromFilenameFilter(@Nonnull FilenameFilter aFilenameFilter) {
        if (aFilenameFilter == null) {
            throw new NullPointerException("filenameFilter");
        }
        this.m_aFilenameFilter = aFilenameFilter;
    }

    @Override
    public boolean accept(@Nullable File aFile) {
        return aFile != null && aFile.isDirectory() && this.m_aFilenameFilter.accept(aFile.getParentFile(), aFile.getName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof FileFilterDirectoryFromFilenameFilter;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("filenameFilter", this.m_aFilenameFilter).toString();
    }
}

