/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.filter;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FilenameFilterStartsWith
implements FilenameFilter {
    private final String m_sPrefix;

    public FilenameFilterStartsWith(@Nonnull @Nonempty String sPrefix) {
        if (StringHelper.hasNoText(sPrefix)) {
            throw new IllegalArgumentException("prefix may not be empty");
        }
        this.m_sPrefix = sPrefix;
    }

    @Override
    public boolean accept(@Nullable File aDir, @Nullable String sName) {
        String sRealName = FilenameHelper.getSecureFilename(sName);
        return sRealName != null && sRealName.startsWith(this.m_sPrefix);
    }

    public String toString() {
        return new ToStringGenerator(this).append("prefix", this.m_sPrefix).toString();
    }
}

