/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.iterate;

import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.collections.iterate.IterableIterator;
import com.phloc.commons.filter.IFilter;
import com.phloc.commons.filter.collections.FilterIterator;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.file.filter.FileFilterToIFilterAdapter;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class FileSystemIterator
extends IterableIterator<File> {
    public FileSystemIterator(@Nonnull String sBaseDir) {
        this(new File(sBaseDir));
    }

    public FileSystemIterator(@Nonnull File aBaseDir) {
        super(FileUtils.getDirectoryContent(aBaseDir));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String sBaseDir, @Nonnull FilenameFilter aFilenameFilter) {
        return new FilterIterator<File>(new FileSystemIterator(sBaseDir), (IFilter<File>)new FileFilterToIFilterAdapter(aFilenameFilter));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File fBaseDir, @Nonnull FilenameFilter aFilenameFilter) {
        return new FilterIterator<File>(new FileSystemIterator(fBaseDir), (IFilter<File>)new FileFilterToIFilterAdapter(aFilenameFilter));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String sBaseDir, FilenameFilter ... aFilenameFilters) {
        return new FilterIterator<File>(new FileSystemIterator(sBaseDir), FileFilterToIFilterAdapter.getANDChained(aFilenameFilters));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File fBaseDir, FilenameFilter ... aFilenameFilters) {
        return new FilterIterator<File>(new FileSystemIterator(fBaseDir), FileFilterToIFilterAdapter.getANDChained(aFilenameFilters));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String sBaseDir, @Nonnull FileFilter aFileFilter) {
        return new FilterIterator<File>(new FileSystemIterator(sBaseDir), (IFilter<File>)new FileFilterToIFilterAdapter(aFileFilter));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File fBaseDir, @Nonnull FileFilter aFileFilter) {
        return new FilterIterator<File>(new FileSystemIterator(fBaseDir), (IFilter<File>)new FileFilterToIFilterAdapter(aFileFilter));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String sBaseDir, FileFilter ... aFileFilters) {
        return new FilterIterator<File>(new FileSystemIterator(sBaseDir), FileFilterToIFilterAdapter.getANDChained(aFileFilters));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File fBaseDir, FileFilter ... aFileFilters) {
        return new FilterIterator<File>(new FileSystemIterator(fBaseDir), FileFilterToIFilterAdapter.getANDChained(aFileFilters));
    }
}

