/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.io.streams.WrappedOutputStream;
import com.phloc.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CountingOutputStream
extends WrappedOutputStream {
    private long m_nBytesWritten = 0L;

    public CountingOutputStream(@Nonnull OutputStream aSourceOS) {
        super(aSourceOS);
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        ++this.m_nBytesWritten;
    }

    @Override
    public void write(byte[] b, int nOffset, int nLength) throws IOException {
        super.write(b, nOffset, nLength);
        this.m_nBytesWritten += (long)nLength;
    }

    @Nonnegative
    public long getBytesWritten() {
        return this.m_nBytesWritten;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("bytesWritten", this.m_nBytesWritten).toString();
    }
}

