/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.io.streams.WrappedInputStream;
import com.phloc.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugInputStream
extends WrappedInputStream {
    private static final Logger s_aLogger = LoggerFactory.getLogger(DebugInputStream.class);
    private long m_nPosition = 0L;

    public DebugInputStream(@Nonnull InputStream aSourceIS) {
        super(aSourceIS);
    }

    public final long getPosition() {
        return this.m_nPosition;
    }

    @OverrideOnDemand
    protected void onRead(int nBytesRead, long nNewPosition) {
        s_aLogger.info("Read " + nBytesRead + " byte(s); now at " + nNewPosition);
    }

    @OverrideOnDemand
    protected void onSkip(long nBytesSkipped, long nNewPosition) {
        s_aLogger.info("Skipped " + nBytesSkipped + " byte(s); now at " + nNewPosition);
    }

    @Override
    public final int read() throws IOException {
        int ret = super.read();
        if (ret != -1) {
            ++this.m_nPosition;
            this.onRead(1, this.m_nPosition);
        }
        return ret;
    }

    @Override
    public final int read(byte[] b, int nOffset, int nLength) throws IOException {
        int ret = super.read(b, nOffset, nLength);
        if (ret != -1) {
            this.m_nPosition += (long)ret;
            this.onRead(ret, this.m_nPosition);
        }
        return ret;
    }

    @Override
    public final long skip(@Nonnegative long n) throws IOException {
        long nSkipped = super.skip(n);
        if (nSkipped > 0L) {
            this.m_nPosition += nSkipped;
            this.onSkip(nSkipped, this.m_nPosition);
        }
        return nSkipped;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("position", this.m_nPosition).toString();
    }
}

