/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.jaxb;

import com.phloc.commons.GlobalDebug;
import com.phloc.commons.cache.AbstractNotifyingCache;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JAXBContextCache
extends AbstractNotifyingCache<Package, JAXBContext> {
    private static final JAXBContextCache s_aInstance = new JAXBContextCache();
    private static final Logger s_aLogger = LoggerFactory.getLogger(JAXBContextCache.class);

    private JAXBContextCache() {
        super(JAXBContextCache.class.getName());
    }

    @Nonnull
    public static JAXBContextCache getInstance() {
        return s_aInstance;
    }

    @Override
    @Nullable
    public JAXBContext getValueToCache(@Nullable Package aPackage) {
        if (aPackage == null) {
            return null;
        }
        if (GlobalDebug.isDebugMode()) {
            s_aLogger.info("Creating JAXB context for package " + aPackage.getName());
        }
        try {
            if (aPackage.getAnnotation(XmlSchema.class) == null) {
                s_aLogger.warn("The package " + aPackage.getName() + " does not seem to be JAXB generated!");
            }
            return JAXBContext.newInstance((String)aPackage.getName());
        }
        catch (JAXBException ex) {
            String sMsg = "Failed to create JAXB context for package " + aPackage.getName();
            s_aLogger.error(sMsg);
            throw new IllegalArgumentException(sMsg, ex);
        }
    }

    @Override
    @Nullable
    public JAXBContext getFromCache(@Nonnull Class<?> aClass) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        Package aPackage = aClass.getPackage();
        if (aPackage.getAnnotation(XmlSchema.class) == null) {
            if (GlobalDebug.isDebugMode()) {
                s_aLogger.info("Creating JAXB context for class " + aClass.getName());
            }
            try {
                return JAXBContext.newInstance((Class[])new Class[]{aClass});
            }
            catch (JAXBException ex) {
                String sMsg = "Failed to create JAXB context for class " + aClass.getName();
                s_aLogger.error(sMsg);
                throw new IllegalArgumentException(sMsg, ex);
            }
        }
        return (JAXBContext)this.getFromCache(aPackage);
    }
}

