/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.LRUCache;
import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.collections.iterate.IterableIterator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ClassHierarchyCache {
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<String, ClassList> s_aClassHierarchy = new LRUCache<String, ClassList>(1000);

    private ClassHierarchyCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearClassHierarchyCache() {
        s_aRWLock.writeLock().lock();
        try {
            s_aClassHierarchy.clear();
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    static ClassList getClassList(@Nonnull Class<?> aClass) {
        ClassList aClassList;
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        String sKey = aClass.getName();
        s_aRWLock.readLock().lock();
        try {
            aClassList = s_aClassHierarchy.get(sKey);
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        if (aClassList == null) {
            s_aRWLock.writeLock().lock();
            try {
                aClassList = s_aClassHierarchy.get(sKey);
                if (aClassList == null) {
                    aClassList = new ClassList(aClass);
                    s_aClassHierarchy.put(sKey, aClassList);
                }
            }
            finally {
                s_aRWLock.writeLock().unlock();
            }
        }
        return aClassList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Class<?>> getClassHierarchy(@Nonnull Class<?> aClass) {
        return ClassHierarchyCache.getClassList(aClass).getAsSet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Class<?>> getClassHierarchyList(@Nonnull Class<?> aClass) {
        return ClassHierarchyCache.getClassList(aClass).getAsList();
    }

    @Nonnull
    public static Iterable<WeakReference<Class<?>>> getClassHierarchyIterator(@Nonnull Class<?> aClass) {
        return ClassHierarchyCache.getClassList(aClass);
    }

    @Immutable
    private static final class ClassList
    implements Iterable<WeakReference<Class<?>>> {
        private final List<WeakReference<Class<?>>> m_aList = new ArrayList();

        public ClassList(@Nonnull Class<?> aClass) {
            if (aClass == null) {
                throw new NullPointerException("class");
            }
            LinkedHashSet<Class> aUniqueOrderedClasses = new LinkedHashSet<Class>();
            ArrayList aOpenSrc = new ArrayList();
            aOpenSrc.add(aClass);
            while (!aOpenSrc.isEmpty()) {
                Class aCurClass = (Class)aOpenSrc.remove(0);
                aUniqueOrderedClasses.add(aCurClass);
                for (Class<?> aInterface : aCurClass.getInterfaces()) {
                    aOpenSrc.add(0, aInterface);
                }
                if (aCurClass.getSuperclass() == null) continue;
                aOpenSrc.add(0, aCurClass.getSuperclass());
            }
            for (Class aCurClass : aUniqueOrderedClasses) {
                this.m_aList.add(new WeakReference<Class>(aCurClass));
            }
        }

        @Nonnull
        @ReturnsMutableCopy
        public Set<Class<?>> getAsSet() {
            LinkedHashSet ret = new LinkedHashSet(this.m_aList.size());
            for (WeakReference<Class<?>> aRef : this.m_aList) {
                Class aClass = (Class)aRef.get();
                if (aClass == null) continue;
                ret.add(aClass);
            }
            return ret;
        }

        @Nonnull
        @ReturnsMutableCopy
        public List<Class<?>> getAsList() {
            ArrayList ret = new ArrayList(this.m_aList.size());
            for (WeakReference<Class<?>> aRef : this.m_aList) {
                Class aClass = (Class)aRef.get();
                if (aClass == null) continue;
                ret.add(aClass);
            }
            return ret;
        }

        @Override
        @Nonnull
        public IIterableIterator<WeakReference<Class<?>>> iterator() {
            return IterableIterator.create(this.m_aList);
        }
    }
}

