/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.locale;

import com.phloc.commons.CGlobal;
import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.cache.AbstractNotifyingCache;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.locale.ELocaleName;
import com.phloc.commons.locale.LocaleCache;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.system.SystemHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class LocaleUtils {
    private static final LocaleListCache s_aLocaleListResolver = new LocaleListCache();
    private static final LocaleUtils s_aInstance = new LocaleUtils();

    private LocaleUtils() {
    }

    @Nonnull
    public static String getLocaleDisplayName(@Nullable Locale aLocale, @Nonnull Locale aContentLocale) {
        if (aLocale == null || aLocale.equals(CGlobal.LOCALE_INDEPENDENT)) {
            return ELocaleName.ID_LANGUAGE_INDEPENDENT.getDisplayText(aContentLocale);
        }
        if (aLocale.equals(CGlobal.LOCALE_ALL)) {
            return ELocaleName.ID_LANGUAGE_ALL.getDisplayText(aContentLocale);
        }
        return aLocale.getDisplayName(aContentLocale);
    }

    @Nonnull
    public static String getLocaleNativeDisplayName(@Nonnull Locale aLocale) {
        if (aLocale == null) {
            throw new NullPointerException("locale");
        }
        return LocaleUtils.getLocaleDisplayName(aLocale, aLocale);
    }

    @Nonnull
    public static Map<Locale, String> getAllLocaleDisplayNames(@Nonnull Locale aContentLocale) {
        HashMap<Locale, String> ret = new HashMap<Locale, String>();
        for (Locale aCurLocale : LocaleCache.getAllLocales()) {
            ret.put(aCurLocale, LocaleUtils.getLocaleDisplayName(aCurLocale, aContentLocale));
        }
        return ret;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Locale> getCalculatedLocaleListForResolving(@Nonnull Locale aLocale) {
        if (aLocale == null) {
            throw new NullPointerException("locale");
        }
        return (List)s_aLocaleListResolver.getFromCache(aLocale);
    }

    @Nonnull
    public static Locale getLocaleFromString(@Nullable String sLocaleAsString) {
        String sVariant;
        String sCountry;
        String sLanguage;
        if (StringHelper.hasNoText(sLocaleAsString)) {
            return SystemHelper.getSystemLocale();
        }
        int i1 = sLocaleAsString.indexOf(95);
        if (i1 < 0) {
            sLanguage = sLocaleAsString;
            sCountry = "";
            sVariant = "";
        } else {
            int i2;
            sLanguage = sLocaleAsString.substring(0, i1);
            if ((i2 = sLocaleAsString.indexOf(95, ++i1)) < 0) {
                sCountry = sLocaleAsString.substring(i1);
                sVariant = "";
            } else {
                sCountry = sLocaleAsString.substring(i1, i2);
                sVariant = sLocaleAsString.substring(i2 + 1);
            }
        }
        sLanguage = sLanguage.length() == 2 ? sLanguage.toLowerCase() : "";
        sCountry = sCountry.length() == 2 ? sCountry.toUpperCase() : "";
        sVariant = sVariant.length() > 0 && (sLanguage.length() == 2 || sCountry.length() == 2) ? sVariant.toUpperCase() : "";
        return LocaleCache.getLocale(sLanguage, sCountry, sVariant);
    }

    @Nullable
    public static Locale getLocaleToUseOrNull(@Nonnull Locale aRequestLocale, @Nonnull Collection<Locale> aAvailableLocales) {
        return LocaleUtils.getLocaleToUseOrFallback(aRequestLocale, aAvailableLocales, null);
    }

    @Nullable
    public static Locale getLocaleToUseOrFallback(@Nonnull Locale aRequestLocale, @Nonnull Collection<Locale> aAvailableLocales, @Nullable Locale aFallback) {
        if (aRequestLocale == null) {
            throw new NullPointerException("requestLocale");
        }
        if (aAvailableLocales == null) {
            throw new NullPointerException("providedLocales");
        }
        if (aAvailableLocales.contains(aRequestLocale)) {
            return aRequestLocale;
        }
        for (Locale aCurrentLocale : LocaleUtils.getCalculatedLocaleListForResolving(aRequestLocale)) {
            if (!aAvailableLocales.contains(aCurrentLocale)) continue;
            return aCurrentLocale;
        }
        String sRequestLanguage = aRequestLocale.getLanguage();
        if (sRequestLanguage != null) {
            for (Locale aCurrentAvailableLocale : aAvailableLocales) {
                if (!sRequestLanguage.equals(aCurrentAvailableLocale.getLanguage())) continue;
                return aCurrentAvailableLocale;
            }
        }
        if (aAvailableLocales.contains(CGlobal.LOCALE_ALL)) {
            return CGlobal.LOCALE_ALL;
        }
        if (aAvailableLocales.contains(CGlobal.LOCALE_INDEPENDENT)) {
            return CGlobal.LOCALE_INDEPENDENT;
        }
        return aFallback;
    }

    public static boolean isSpecialLocale(@Nullable Locale aLocale) {
        return CGlobal.LOCALE_ALL.equals(aLocale) || CGlobal.LOCALE_INDEPENDENT.equals(aLocale);
    }

    private static final class LocaleListCache
    extends AbstractNotifyingCache<Locale, List<Locale>> {
        public LocaleListCache() {
            super(LocaleListCache.class.getName());
        }

        @Override
        @Nullable
        protected List<Locale> getValueToCache(@Nullable Locale aBaseLocale) {
            if (aBaseLocale == null) {
                return null;
            }
            ArrayList<Locale> ret = new ArrayList<Locale>(3);
            String sLanguage = aBaseLocale.getLanguage();
            if (sLanguage.length() > 0) {
                ret.add(0, LocaleCache.getLocale(sLanguage));
                String sCountry = aBaseLocale.getCountry();
                if (sCountry.length() > 0) {
                    ret.add(0, LocaleCache.getLocale(sLanguage, sCountry));
                    String sVariant = aBaseLocale.getVariant();
                    if (sVariant.length() > 0) {
                        ret.add(0, LocaleCache.getLocale(sLanguage, sCountry, sVariant));
                    }
                }
            }
            return ContainerHelper.makeUnmodifiable(ret);
        }
    }
}

