/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.messagedigest;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.messagedigest.AbstractMessageDigestGenerator;
import com.phloc.commons.messagedigest.EMessageDigestAlgorithm;
import com.phloc.commons.messagedigest.IMessageDigestGenerator;
import com.phloc.commons.messagedigest.NonBlockingMessageDigestGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class MessageDigestGenerator
extends AbstractMessageDigestGenerator {
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final IMessageDigestGenerator m_aMDGen;

    public MessageDigestGenerator() {
        this(DEFAULT_ALGORITHM);
    }

    public MessageDigestGenerator(EMessageDigestAlgorithm ... aAlgorithms) {
        this.m_aMDGen = new NonBlockingMessageDigestGenerator(aAlgorithms);
    }

    @Override
    @Nonnull
    public String getAlgorithmName() {
        return this.m_aMDGen.getAlgorithmName();
    }

    @Override
    @Nonnegative
    public int getDigestLength() {
        return this.m_aMDGen.getDigestLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public MessageDigestGenerator update(byte aValue) {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMDGen.update(aValue);
            MessageDigestGenerator messageDigestGenerator = this;
            return messageDigestGenerator;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public MessageDigestGenerator update(@Nonnull byte[] aValue, @Nonnegative int nOffset, @Nonnegative int nLength) {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMDGen.update(aValue, nOffset, nLength);
            MessageDigestGenerator messageDigestGenerator = this;
            return messageDigestGenerator;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMDGen.reset();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public byte[] getDigest() {
        this.m_aRWLock.writeLock().lock();
        try {
            byte[] byArray = this.m_aMDGen.getDigest();
            return byArray;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public byte[] getDigest(@Nonnegative int nLength) {
        this.m_aRWLock.writeLock().lock();
        try {
            byte[] byArray = this.m_aMDGen.getDigest(nLength);
            return byArray;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("messageDigestGenerator", this.m_aMDGen).toString();
    }
}

