/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.serialize;

import com.phloc.commons.io.streams.NonBlockingStringWriter;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.serialize.MicroSerializer;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.stats.IStatisticsHandlerSize;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.xml.serialize.IXMLWriterSettings;
import com.phloc.commons.xml.serialize.XMLWriterSettings;
import java.io.OutputStream;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class MicroWriter {
    private static final Logger s_aLogger = LoggerFactory.getLogger(MicroWriter.class);
    private static final IStatisticsHandlerSize s_aSizeHdl = StatisticsManager.getSizeHandler(MicroWriter.class);
    private static final MicroWriter s_aInstance = new MicroWriter();

    private MicroWriter() {
    }

    @Nonnull
    public static ESuccess writeToStream(@Nonnull IMicroNode aNode, @Nonnull @WillClose OutputStream aOS) {
        return MicroWriter.writeToStream(aNode, aOS, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeToStream(@Nonnull IMicroNode aNode, @Nonnull @WillClose OutputStream aOS, @Nonnull IXMLWriterSettings aSettings) {
        if (aNode == null) {
            throw new NullPointerException("node");
        }
        if (aOS == null) {
            throw new NullPointerException("outputStream");
        }
        if (aSettings == null) {
            throw new NullPointerException("settings");
        }
        try {
            MicroSerializer aSerializer = new MicroSerializer(aSettings);
            aSerializer.write(aNode, aOS);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        finally {
            StreamUtils.close(aOS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeToWriter(@Nonnull IMicroNode aNode, @Nonnull @WillClose Writer aWriter, @Nonnull IXMLWriterSettings aSettings) {
        if (aNode == null) {
            throw new NullPointerException("node");
        }
        if (aWriter == null) {
            throw new NullPointerException("writer");
        }
        if (aSettings == null) {
            throw new NullPointerException("settings");
        }
        try {
            MicroSerializer aSerializer = new MicroSerializer(aSettings);
            aSerializer.write(aNode, aWriter);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        finally {
            StreamUtils.close(aWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getNodeAsString(@Nonnull IMicroNode aNode, @Nonnull IXMLWriterSettings aSettings) {
        NonBlockingStringWriter aWriter;
        block6: {
            String string;
            if (aNode == null) {
                throw new NullPointerException("node");
            }
            if (aSettings == null) {
                throw new NullPointerException("settings");
            }
            aWriter = null;
            try {
                aWriter = new NonBlockingStringWriter(51200);
                if (!MicroWriter.writeToWriter(aNode, aWriter, aSettings).isSuccess()) break block6;
                s_aSizeHdl.addSize(aWriter.size());
                string = aWriter.getAsString();
            }
            catch (Throwable t) {
                try {
                    s_aLogger.error("Error serializing MicroDOM with settings " + aSettings.toString(), t);
                }
                catch (Throwable throwable) {
                    StreamUtils.close(aWriter);
                    throw throwable;
                }
                StreamUtils.close(aWriter);
            }
            StreamUtils.close(aWriter);
            return string;
        }
        StreamUtils.close(aWriter);
        return null;
    }

    @Nullable
    public static String getXMLString(@Nonnull IMicroNode aNode) {
        return MicroWriter.getNodeAsString(aNode, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }
}

