/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.parent.utils;

import com.phloc.commons.hierarchy.IHierarchyWalkerCallback;
import com.phloc.commons.parent.IChildrenProvider;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ChildrenProviderWalker<CHILDTYPE> {
    private final IChildrenProvider<CHILDTYPE> m_aChildrenProvider;
    private final IHierarchyWalkerCallback<CHILDTYPE> m_aCallback;

    public ChildrenProviderWalker(@Nonnull IChildrenProvider<CHILDTYPE> aChildrenProvider, @Nonnull IHierarchyWalkerCallback<CHILDTYPE> aCallback) {
        if (aChildrenProvider == null) {
            throw new NullPointerException("childProvider");
        }
        if (aCallback == null) {
            throw new NullPointerException("callback");
        }
        this.m_aChildrenProvider = aChildrenProvider;
        this.m_aCallback = aCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _walkRecursive(@Nonnull CHILDTYPE aObject) {
        if (aObject == null) {
            throw new NullPointerException("object");
        }
        this.m_aCallback.onItemBeforeChildren(aObject);
        if (this.m_aChildrenProvider.hasChildren(aObject)) {
            this.m_aCallback.onLevelDown();
            try {
                for (CHILDTYPE aChildObject : this.m_aChildrenProvider.getChildren(aObject)) {
                    this._walkRecursive(aChildObject);
                }
            }
            finally {
                this.m_aCallback.onLevelUp();
            }
        }
        this.m_aCallback.onItemAfterChildren(aObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walk() {
        this.m_aCallback.begin();
        try {
            if (this.m_aChildrenProvider.hasChildren(null)) {
                for (CHILDTYPE CHILDTYPE : this.m_aChildrenProvider.getChildren(null)) {
                    this._walkRecursive(CHILDTYPE);
                }
            }
        }
        finally {
            this.m_aCallback.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walkSub(@Nonnull CHILDTYPE aObject) {
        if (aObject == null) {
            throw new NullPointerException("object");
        }
        this.m_aCallback.begin();
        try {
            this._walkRecursive(aObject);
        }
        finally {
            this.m_aCallback.end();
        }
    }

    public static <CHILDTYPE> void walkProvider(@Nonnull IChildrenProvider<CHILDTYPE> aChildProvider, @Nonnull IHierarchyWalkerCallback<CHILDTYPE> aCallback) {
        new ChildrenProviderWalker<CHILDTYPE>(aChildProvider, aCallback).walk();
    }

    public static <CHILDTYPE> void walkSubProvider(@Nonnull CHILDTYPE aObject, @Nonnull IChildrenProvider<CHILDTYPE> aChildProvider, @Nonnull IHierarchyWalkerCallback<CHILDTYPE> aCallback) {
        new ChildrenProviderWalker<CHILDTYPE>(aChildProvider, aCallback).walkSub(aObject);
    }
}

