/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.parent.utils;

import com.phloc.commons.hierarchy.EHierarchyCallbackReturn;
import com.phloc.commons.hierarchy.IHierarchyWalkerDynamicCallback;
import com.phloc.commons.parent.IChildrenProvider;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ChildrenProviderWalkerDynamic<CHILDTYPE> {
    private final IChildrenProvider<CHILDTYPE> m_aChildrenProvider;
    private final IHierarchyWalkerDynamicCallback<CHILDTYPE> m_aCallback;

    public ChildrenProviderWalkerDynamic(@Nonnull IChildrenProvider<CHILDTYPE> aChildrenProvider, @Nonnull IHierarchyWalkerDynamicCallback<CHILDTYPE> aCallback) {
        if (aChildrenProvider == null) {
            throw new NullPointerException("childProvider");
        }
        if (aCallback == null) {
            throw new NullPointerException("callback");
        }
        this.m_aChildrenProvider = aChildrenProvider;
        this.m_aCallback = aCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private EHierarchyCallbackReturn _walkRecursive(CHILDTYPE aObject) {
        EHierarchyCallbackReturn eRetPrefix = this.m_aCallback.onItemBeforeChildren(aObject);
        EHierarchyCallbackReturn eRetChildren = EHierarchyCallbackReturn.CONTINUE;
        if (eRetPrefix == EHierarchyCallbackReturn.CONTINUE && this.m_aChildrenProvider.hasChildren(aObject)) {
            this.m_aCallback.onLevelDown();
            try {
                for (CHILDTYPE aChildObject : this.m_aChildrenProvider.getChildren(aObject)) {
                    eRetChildren = this._walkRecursive(aChildObject);
                    if (eRetChildren == EHierarchyCallbackReturn.USE_PARENTS_NEXT_SIBLING) {
                        eRetChildren = EHierarchyCallbackReturn.CONTINUE;
                    } else if (eRetChildren != EHierarchyCallbackReturn.STOP_ITERATION) continue;
                    break;
                }
            }
            finally {
                this.m_aCallback.onLevelUp();
            }
        }
        EHierarchyCallbackReturn eRetPostfix = this.m_aCallback.onItemAfterChildren(aObject);
        if (eRetPrefix == EHierarchyCallbackReturn.STOP_ITERATION || eRetChildren == EHierarchyCallbackReturn.STOP_ITERATION || eRetPostfix == EHierarchyCallbackReturn.STOP_ITERATION) {
            return EHierarchyCallbackReturn.STOP_ITERATION;
        }
        if (eRetPrefix == EHierarchyCallbackReturn.USE_PARENTS_NEXT_SIBLING || eRetChildren == EHierarchyCallbackReturn.USE_PARENTS_NEXT_SIBLING || eRetPostfix == EHierarchyCallbackReturn.USE_PARENTS_NEXT_SIBLING) {
            return EHierarchyCallbackReturn.USE_PARENTS_NEXT_SIBLING;
        }
        return EHierarchyCallbackReturn.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walk() {
        this.m_aCallback.begin();
        try {
            if (this.m_aChildrenProvider.hasChildren(null)) {
                for (CHILDTYPE CHILDTYPE : this.m_aChildrenProvider.getChildren(null)) {
                    this._walkRecursive(CHILDTYPE);
                }
            }
        }
        finally {
            this.m_aCallback.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walkSub(@Nonnull CHILDTYPE aObject) {
        if (aObject == null) {
            throw new NullPointerException("object");
        }
        this.m_aCallback.begin();
        try {
            this._walkRecursive(aObject);
        }
        finally {
            this.m_aCallback.end();
        }
    }

    public static <CHILDTYPE> void walkProvider(@Nonnull IChildrenProvider<CHILDTYPE> aChildrenProvider, @Nonnull IHierarchyWalkerDynamicCallback<CHILDTYPE> aCallback) {
        new ChildrenProviderWalkerDynamic<CHILDTYPE>(aChildrenProvider, aCallback).walk();
    }

    public static <CHILDTYPE> void walkSubProvider(@Nonnull CHILDTYPE aObject, @Nonnull IChildrenProvider<CHILDTYPE> aChildrenProvider, @Nonnull IHierarchyWalkerDynamicCallback<CHILDTYPE> aCallback) {
        new ChildrenProviderWalkerDynamic<CHILDTYPE>(aChildrenProvider, aCallback).walkSub(aObject);
    }
}

