/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.state.impl;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mutable.IReadonlyWrapper;
import com.phloc.commons.state.EChange;
import com.phloc.commons.state.IChangeIndicator;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ChangeWithValue<DATATYPE>
implements IChangeIndicator,
IReadonlyWrapper<DATATYPE> {
    private final EChange m_eChange;
    private final DATATYPE m_aObj;

    public ChangeWithValue(@Nonnull IChangeIndicator aChangeIndicator, @Nullable DATATYPE aObj) {
        if (aChangeIndicator == null) {
            throw new NullPointerException("changeIndicator");
        }
        this.m_eChange = EChange.valueOf(aChangeIndicator);
        this.m_aObj = aObj;
    }

    @Override
    public boolean isChanged() {
        return this.m_eChange.isChanged();
    }

    @Override
    public boolean isUnchanged() {
        return this.m_eChange.isUnchanged();
    }

    @Override
    @Nullable
    public DATATYPE get() {
        return this.m_aObj;
    }

    @Nullable
    public DATATYPE getIfChanged(@Nullable DATATYPE aUnchangedValue) {
        return this.m_eChange.isChanged() ? this.m_aObj : aUnchangedValue;
    }

    @Nullable
    public DATATYPE getIfChangedOrNull() {
        return this.getIfChanged(null);
    }

    @Nullable
    public DATATYPE getIfUnchanged(@Nullable DATATYPE aChangedValue) {
        return this.m_eChange.isUnchanged() ? this.m_aObj : aChangedValue;
    }

    @Nullable
    public DATATYPE getIfUnchangedOrNull() {
        return this.getIfUnchanged(null);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeWithValue)) {
            return false;
        }
        ChangeWithValue rhs = (ChangeWithValue)o;
        return this.m_eChange.equals(rhs.m_eChange) && EqualsUtils.equals(this.m_aObj, rhs.m_aObj);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eChange)).append(this.m_aObj).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("change", this.m_eChange).append("obj", this.m_aObj).toString();
    }

    @Nonnull
    public static <DATATYPE> ChangeWithValue<DATATYPE> createChanged(@Nullable DATATYPE aValue) {
        return new ChangeWithValue<DATATYPE>(EChange.CHANGED, aValue);
    }

    @Nonnull
    public static <DATATYPE> ChangeWithValue<DATATYPE> createUnchanged(@Nullable DATATYPE aValue) {
        return new ChangeWithValue<DATATYPE>(EChange.UNCHANGED, aValue);
    }
}

