/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.impl;

import com.phloc.commons.text.ITextProvider;
import com.phloc.commons.text.impl.TextFormatter;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractTextProvider
implements ITextProvider {
    protected AbstractTextProvider() {
    }

    @Nullable
    protected abstract String internalGetText(@Nonnull Locale var1);

    @Nullable
    protected abstract Locale internalGetLocaleToUseWithFallback(@Nonnull Locale var1);

    @Override
    @Nullable
    public final String getText(@Nonnull Locale aContentLocale) {
        if (aContentLocale == null) {
            throw new NullPointerException("locale");
        }
        return this.internalGetText(aContentLocale);
    }

    @Override
    @Nullable
    public final String getTextWithLocaleFallback(@Nonnull Locale aContentLocale) {
        if (aContentLocale == null) {
            throw new NullPointerException("locale");
        }
        Locale aLocaleToUse = this.internalGetLocaleToUseWithFallback(aContentLocale);
        return aLocaleToUse == null ? null : this.internalGetText(aLocaleToUse);
    }

    @Override
    @Nullable
    public final String getTextWithArgs(@Nonnull Locale aContentLocale, Object ... aArgs) {
        String sText = this.getText(aContentLocale);
        return TextFormatter.getFormattedText(sText, aArgs);
    }

    @Override
    @Nullable
    public final String getTextWithLocaleFallbackAndArgs(@Nonnull Locale aContentLocale, Object ... aArgs) {
        String sText = this.getTextWithLocaleFallback(aContentLocale);
        return TextFormatter.getFormattedText(sText, aArgs);
    }
}

