/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.impl;

import com.phloc.commons.GlobalDebug;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.annotations.ReturnsMutableObject;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.locale.LocaleCache;
import com.phloc.commons.locale.LocaleUtils;
import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.text.ISimpleMultiLingualText;
import com.phloc.commons.text.impl.AbstractTextProvider;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public class TextProvider
extends AbstractTextProvider
implements ISimpleMultiLingualText {
    public static final Locale DE = LocaleCache.getLocale("de");
    public static final Locale EN = LocaleCache.getLocale("en");
    private final Map<Locale, String> m_aTexts = new HashMap<Locale, String>();

    protected TextProvider() {
    }

    private static void _performDebugOnlyConsistencyChecks(@Nonnull String sValue) {
        if (sValue.indexOf("\\n") >= 0) {
            throw new IllegalArgumentException("Passed string contains a masked newline - replace with an inline one!");
        }
        if (sValue.indexOf("{0}") >= 0) {
            if (RegExHelper.stringMatchesPattern("^'[^'].*", sValue)) {
                throw new IllegalArgumentException("The passed string seems to start with unclosed single quotes: " + sValue);
            }
            if (RegExHelper.stringMatchesPattern(".*[^']'[^'].*", sValue)) {
                throw new IllegalArgumentException("The passed string seems to contain unclosed single quotes: " + sValue);
            }
        } else if (RegExHelper.stringMatchesPattern(".*''.*", sValue)) {
            throw new IllegalArgumentException("The passed string seems to contain 2 single quotes: " + sValue);
        }
    }

    @Nonnull
    protected final TextProvider internalAddText(@Nonnull Locale aContentLocale, @Nonnull String sValue) {
        if (this.m_aTexts.containsKey(aContentLocale)) {
            throw new IllegalArgumentException("Locale '" + aContentLocale + "' already contained in TextProvider: " + this.toString());
        }
        return this.internalSetText(aContentLocale, sValue);
    }

    @Nonnull
    protected final TextProvider internalSetText(@Nonnull Locale aContentLocale, @Nullable String sValue) {
        if (GlobalDebug.isDebugMode() && sValue != null) {
            TextProvider._performDebugOnlyConsistencyChecks(sValue);
        }
        this.m_aTexts.put(aContentLocale, sValue);
        return this;
    }

    @Nonnull
    protected final EChange internalRemoveText(@Nullable Locale aLocale) {
        return EChange.valueOf(this.m_aTexts.remove(aLocale) != null);
    }

    @Nonnull
    protected final EChange internalClear() {
        if (this.m_aTexts.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aTexts.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    public final TextProvider addTextDE(@Nonnull String sDE) {
        return this.internalAddText(DE, sDE);
    }

    @Nonnull
    public final TextProvider addTextEN(@Nonnull String sEN) {
        return this.internalAddText(EN, sEN);
    }

    @Nonnull
    @ReturnsMutableObject(reason="Internal use only")
    protected final Map<Locale, String> internalGetMap() {
        return this.m_aTexts;
    }

    @Override
    @Nullable
    protected final Locale internalGetLocaleToUseWithFallback(@Nonnull Locale aContentLocale) {
        return LocaleUtils.getLocaleToUseOrNull(aContentLocale, this.m_aTexts.keySet());
    }

    @Override
    @Nullable
    @OverrideOnDemand
    protected String internalGetText(@Nonnull Locale aContentLocale) {
        return this.m_aTexts.get(aContentLocale);
    }

    @Nonnull
    @ReturnsMutableObject(reason="Internal use only")
    public final Set<Locale> internalGetAllLocales() {
        return this.m_aTexts.keySet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public final Set<Locale> getAllLocales() {
        return ContainerHelper.newSet(this.m_aTexts.keySet());
    }

    public final boolean containsLocale(@Nullable Locale aLocale) {
        return this.m_aTexts.containsKey(aLocale);
    }

    public final boolean containsLocaleWithFallback(@Nullable Locale aContentLocale) {
        if (aContentLocale != null) {
            for (Locale aCurrentLocale : LocaleUtils.getCalculatedLocaleListForResolving(aContentLocale)) {
                if (!this.containsLocale(aCurrentLocale)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final Map<Locale, String> getMap() {
        return ContainerHelper.newMap(this.m_aTexts);
    }

    @Override
    @Nonnegative
    public final int size() {
        return this.m_aTexts.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.m_aTexts.isEmpty();
    }

    @OverridingMethodsMustInvokeSuper
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        TextProvider rhs = (TextProvider)o;
        return ((Object)this.m_aTexts).equals(rhs.m_aTexts);
    }

    @OverridingMethodsMustInvokeSuper
    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aTexts)).getHashCode();
    }

    @OverridingMethodsMustInvokeSuper
    public String toString() {
        return new ToStringGenerator(this).append("texts", this.m_aTexts).toString();
    }

    @Nonnull
    public static ISimpleMultiLingualText create_DE(@Nonnull String sDE) {
        return new TextProvider().addTextDE(sDE);
    }

    @Nonnull
    public static ISimpleMultiLingualText create_EN(@Nonnull String sEN) {
        return new TextProvider().addTextEN(sEN);
    }

    @Nonnull
    public static ISimpleMultiLingualText create_DE_EN(@Nonnull String sDE, @Nonnull String sEN) {
        return new TextProvider().addTextDE(sDE).addTextEN(sEN);
    }
}

