/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.thirdparty;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.lang.ServiceLoaderBackport;
import com.phloc.commons.state.EChange;
import com.phloc.commons.thirdparty.IThirdPartyModule;
import com.phloc.commons.thirdparty.IThirdPartyModuleProviderSPI;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ThirdPartyModuleRegistry {
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Set<IThirdPartyModule> s_aModules = new LinkedHashSet<IThirdPartyModule>();
    private static final ThirdPartyModuleRegistry s_aInstance;

    private ThirdPartyModuleRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange registerThirdPartyModule(@Nonnull IThirdPartyModule aModule) {
        if (aModule == null) {
            throw new NullPointerException("module");
        }
        s_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(s_aModules.add(aModule));
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<IThirdPartyModule> getAllRegisteredThirdPartyModules() {
        s_aRWLock.readLock().lock();
        try {
            Set<IThirdPartyModule> set = ContainerHelper.newSet(s_aModules);
            return set;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    static {
        for (IThirdPartyModuleProviderSPI aTPM : ServiceLoaderBackport.load(IThirdPartyModuleProviderSPI.class)) {
            IThirdPartyModule[] aModules = aTPM.getAllThirdPartyModules();
            if (aModules == null) continue;
            for (IThirdPartyModule aModule : aModules) {
                ThirdPartyModuleRegistry.registerThirdPartyModule(aModule);
            }
        }
        s_aInstance = new ThirdPartyModuleRegistry();
    }
}

