/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.utils.search;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.hierarchy.DefaultHierarchyWalkerCallback;
import com.phloc.commons.tree.IBasicTree;
import com.phloc.commons.tree.utils.walk.TreeWalker;
import com.phloc.commons.tree.withid.ITreeItemWithID;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeWithIDSearcher {
    private static final TreeWithIDSearcher s_aInstance = new TreeWithIDSearcher();

    private TreeWithIDSearcher() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>> List<ITEMTYPE> findAllItemsWithIDRecursive(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree, @Nullable KEYTYPE aSearchID) {
        return TreeWithIDSearcher.findAllItemsWithIDRecursive((ITreeItemWithID)aTree.getRootItem(), aSearchID);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>> List<ITEMTYPE> findAllItemsWithIDRecursive(@Nonnull ITEMTYPE aTreeItem, final @Nullable KEYTYPE aSearchID) {
        final ArrayList aRetList = new ArrayList();
        TreeWalker.walkSubTree(aTreeItem, new DefaultHierarchyWalkerCallback<ITEMTYPE>(){

            @Override
            public void onItemBeforeChildren(@Nullable ITEMTYPE aItem) {
                if (aItem != null && aItem.getID().equals(aSearchID)) {
                    aRetList.add(aItem);
                }
            }
        });
        return aRetList;
    }
}

