/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.utils.sort;

import com.phloc.commons.hierarchy.DefaultHierarchyWalkerCallback;
import com.phloc.commons.tree.IBasicTree;
import com.phloc.commons.tree.simple.ITreeItem;
import com.phloc.commons.tree.utils.sort.ComparatorTreeItemValue;
import com.phloc.commons.tree.utils.sort.ComparatorTreeItemValueComparable;
import com.phloc.commons.tree.utils.walk.TreeWalker;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeSorter {
    private static final TreeSorter s_aInstance = new TreeSorter();

    private TreeSorter() {
    }

    private static <VALUETYPE, ITEMTYPE extends ITreeItem<VALUETYPE, ITEMTYPE>> void _sort(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree, final @Nonnull Comparator<? super ITEMTYPE> aComparator) {
        if (aTree == null) {
            throw new NullPointerException("tree");
        }
        if (aComparator == null) {
            throw new NullPointerException("comparator");
        }
        ((ITreeItem)aTree.getRootItem()).reorderChildItems(aComparator);
        TreeWalker.walkTree(aTree, new DefaultHierarchyWalkerCallback<ITEMTYPE>(){

            @Override
            public void onItemBeforeChildren(@Nullable ITEMTYPE aTreeItem) {
                if (aTreeItem != null) {
                    aTreeItem.reorderChildItems(aComparator);
                }
            }
        });
    }

    public static <VALUETYPE, ITEMTYPE extends ITreeItem<VALUETYPE, ITEMTYPE>> void sort(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree, @Nonnull Comparator<? super VALUETYPE> aValueComparator) {
        ComparatorTreeItemValue aItemComp = new ComparatorTreeItemValue(aValueComparator);
        TreeSorter._sort(aTree, aItemComp);
    }

    public static <VALUETYPE extends Comparable<? super VALUETYPE>, ITEMTYPE extends ITreeItem<VALUETYPE, ITEMTYPE>> void sort(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree) {
        ComparatorTreeItemValueComparable aItemComp = new ComparatorTreeItemValueComparable();
        TreeSorter._sort(aTree, aItemComp);
    }
}

