/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.utils.walk;

import com.phloc.commons.hierarchy.EHierarchyCallbackReturn;
import com.phloc.commons.hierarchy.IHierarchyWalkerDynamicCallback;
import com.phloc.commons.parent.IChildrenProvider;
import com.phloc.commons.parent.impl.ChildrenProviderHasChildren;
import com.phloc.commons.tree.IBasicTree;
import com.phloc.commons.tree.IBasicTreeItem;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeWalkerDynamic {
    private static final TreeWalkerDynamic s_aInstance = new TreeWalkerDynamic();

    private TreeWalkerDynamic() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static <VALUETYPE, ITEMTYPE extends IBasicTreeItem<VALUETYPE, ITEMTYPE>> EHierarchyCallbackReturn _walkTree(@Nonnull ITEMTYPE aTreeItem, @Nonnull IChildrenProvider<ITEMTYPE> aChildrenProvider, @Nonnull IHierarchyWalkerDynamicCallback<? super ITEMTYPE> aCallback) {
        EHierarchyCallbackReturn eRetPrefix = aCallback.onItemBeforeChildren(aTreeItem);
        EHierarchyCallbackReturn eRetChildren = EHierarchyCallbackReturn.CONTINUE;
        if (eRetPrefix == EHierarchyCallbackReturn.CONTINUE && aChildrenProvider.hasChildren(aTreeItem)) {
            aCallback.onLevelDown();
            try {
                for (IBasicTreeItem aChildItem : aChildrenProvider.getChildren(aTreeItem)) {
                    eRetChildren = TreeWalkerDynamic._walkTree(aChildItem, aChildrenProvider, aCallback);
                    if (eRetChildren == EHierarchyCallbackReturn.USE_PARENTS_NEXT_SIBLING) {
                        eRetChildren = EHierarchyCallbackReturn.CONTINUE;
                    } else if (eRetChildren != EHierarchyCallbackReturn.STOP_ITERATION) continue;
                    break;
                }
            }
            finally {
                aCallback.onLevelUp();
            }
        }
        EHierarchyCallbackReturn eRetPostfix = aCallback.onItemAfterChildren(aTreeItem);
        if (eRetPrefix == EHierarchyCallbackReturn.STOP_ITERATION || eRetChildren == EHierarchyCallbackReturn.STOP_ITERATION || eRetPostfix == EHierarchyCallbackReturn.STOP_ITERATION) {
            return EHierarchyCallbackReturn.STOP_ITERATION;
        }
        if (eRetPrefix == EHierarchyCallbackReturn.USE_PARENTS_NEXT_SIBLING || eRetChildren == EHierarchyCallbackReturn.USE_PARENTS_NEXT_SIBLING || eRetPostfix == EHierarchyCallbackReturn.USE_PARENTS_NEXT_SIBLING) {
            return EHierarchyCallbackReturn.USE_PARENTS_NEXT_SIBLING;
        }
        return EHierarchyCallbackReturn.CONTINUE;
    }

    public static <VALUETYPE, ITEMTYPE extends IBasicTreeItem<VALUETYPE, ITEMTYPE>> void walkTree(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree, @Nonnull IHierarchyWalkerDynamicCallback<? super ITEMTYPE> aCallback) {
        TreeWalkerDynamic.walkTree(aTree, new ChildrenProviderHasChildren(), aCallback);
    }

    public static <VALUETYPE, ITEMTYPE extends IBasicTreeItem<VALUETYPE, ITEMTYPE>> void walkTree(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree, @Nonnull IChildrenProvider<ITEMTYPE> aChildrenResolver, @Nonnull IHierarchyWalkerDynamicCallback<? super ITEMTYPE> aCallback) {
        if (aTree == null) {
            throw new NullPointerException("tree");
        }
        TreeWalkerDynamic.walkSubTree(aTree.getRootItem(), aChildrenResolver, aCallback);
    }

    public static <VALUETYPE, ITEMTYPE extends IBasicTreeItem<VALUETYPE, ITEMTYPE>> void walkSubTree(@Nonnull ITEMTYPE aTreeItem, @Nonnull IHierarchyWalkerDynamicCallback<? super ITEMTYPE> aCallback) {
        TreeWalkerDynamic.walkSubTree(aTreeItem, new ChildrenProviderHasChildren(), aCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <VALUETYPE, ITEMTYPE extends IBasicTreeItem<VALUETYPE, ITEMTYPE>> void walkSubTree(@Nonnull ITEMTYPE aTreeItem, @Nonnull IChildrenProvider<ITEMTYPE> aChildrenProvider, @Nonnull IHierarchyWalkerDynamicCallback<? super ITEMTYPE> aCallback) {
        if (aTreeItem == null) {
            throw new NullPointerException("treeItem");
        }
        if (aChildrenProvider == null) {
            throw new NullPointerException("childrenProvider");
        }
        if (aCallback == null) {
            throw new NullPointerException("callback");
        }
        aCallback.begin();
        try {
            if (aChildrenProvider.hasChildren(aTreeItem)) {
                for (IBasicTreeItem aChildItem : aChildrenProvider.getChildren(aTreeItem)) {
                    TreeWalkerDynamic._walkTree(aChildItem, aChildrenProvider, aCallback);
                }
            }
        }
        finally {
            aCallback.end();
        }
    }
}

