/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.withid.unique;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.tree.withid.ITreeItemWithID;
import com.phloc.commons.tree.withid.unique.ITreeItemWithUniqueIDFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractTreeItemWithUniqueIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>>
implements ITreeItemWithUniqueIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE> {
    private final Map<KEYTYPE, ITEMTYPE> m_aItemStore;

    public AbstractTreeItemWithUniqueIDFactory() {
        this(new HashMap());
    }

    public AbstractTreeItemWithUniqueIDFactory(@Nonnull Map<KEYTYPE, ITEMTYPE> aItemStore) {
        if (aItemStore == null) {
            throw new NullPointerException("itemStore");
        }
        this.m_aItemStore = aItemStore;
    }

    @Nonnull
    protected final ITEMTYPE addToItemStore(@Nonnull KEYTYPE aDataID, @Nonnull ITEMTYPE aItem) {
        if (this.m_aItemStore.containsKey(aDataID)) {
            throw new IllegalArgumentException("An item with ID '" + aDataID + "' is already contained!");
        }
        this.m_aItemStore.put(aDataID, aItem);
        return aItem;
    }

    @Nonnull
    protected abstract ITEMTYPE internalCreate(@Nonnull ITEMTYPE var1, @Nonnull KEYTYPE var2);

    @Nonnull
    @OverrideOnDemand
    protected KEYTYPE internalGetItemID(@Nonnull ITEMTYPE aItem) {
        return aItem.getID();
    }

    @Override
    @Nonnull
    public final ITEMTYPE create(@Nonnull ITEMTYPE aParent, @Nonnull KEYTYPE aDataID) {
        if (aParent == null) {
            throw new NullPointerException("parent may not be null - use createRoot instead!");
        }
        ITEMTYPE aTreeItem = this.internalCreate(aParent, aDataID);
        return this.addToItemStore(this.internalGetItemID(aTreeItem), aTreeItem);
    }

    @Override
    public final void onRemoveItem(@Nonnull ITEMTYPE aTreeItem) {
        this.m_aItemStore.remove(this.internalGetItemID(aTreeItem));
    }

    @Override
    public final void onAddItem(@Nonnull ITEMTYPE aTreeItem) {
        this.addToItemStore(this.internalGetItemID(aTreeItem), aTreeItem);
    }

    @Override
    @Nullable
    public final ITEMTYPE getItemOfDataID(@Nullable KEYTYPE aDataID) {
        return (ITEMTYPE)((ITreeItemWithID)this.m_aItemStore.get(aDataID));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final Collection<ITEMTYPE> getAllItems() {
        return ContainerHelper.newList(this.m_aItemStore.values());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        AbstractTreeItemWithUniqueIDFactory rhs = (AbstractTreeItemWithUniqueIDFactory)o;
        return ((Object)this.m_aItemStore).equals(rhs.m_aItemStore);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aItemStore)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("itemStoreKeys", this.m_aItemStore.keySet()).toString();
    }
}

