/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.typeconvert.impl;

import com.phloc.commons.annotations.IsSPIImplementation;
import com.phloc.commons.io.EAppend;
import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IOutputStreamProvider;
import com.phloc.commons.io.IReaderProvider;
import com.phloc.commons.io.IResourceBase;
import com.phloc.commons.io.IWriterProvider;
import com.phloc.commons.io.resource.ClassPathResource;
import com.phloc.commons.io.resource.FileSystemResource;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.typeconvert.ITypeConverter;
import com.phloc.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.phloc.commons.typeconvert.ITypeConverterRegistry;
import com.phloc.commons.typeconvert.rule.AbstractTypeConverterRuleAssignableSourceFixedDestination;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class IOTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry aRegistry) {
        aRegistry.registerTypeConverter(File.class, String.class, new ITypeConverter(){

            @Override
            public String convert(@Nonnull Object aSource) {
                return ((File)aSource).getAbsolutePath();
            }
        });
        aRegistry.registerTypeConverter(File.class, URI.class, new ITypeConverter(){

            @Override
            public URI convert(@Nonnull Object aSource) {
                return ((File)aSource).toURI();
            }
        });
        aRegistry.registerTypeConverter(File.class, URL.class, new ITypeConverter(){

            @Override
            public URL convert(@Nonnull Object aSource) {
                try {
                    return ((File)aSource).toURI().toURL();
                }
                catch (MalformedURLException ex) {
                    return null;
                }
            }
        });
        aRegistry.registerTypeConverter(URI.class, File.class, new ITypeConverter(){

            @Override
            public File convert(@Nonnull Object aSource) {
                return new File((URI)aSource);
            }
        });
        aRegistry.registerTypeConverter(URI.class, URL.class, new ITypeConverter(){

            @Override
            public URL convert(@Nonnull Object aSource) {
                try {
                    return ((URI)aSource).toURL();
                }
                catch (MalformedURLException ex) {
                    return null;
                }
            }
        });
        aRegistry.registerTypeConverter(URL.class, String.class, new ITypeConverter(){

            @Override
            public String convert(@Nonnull Object aSource) {
                return ((URL)aSource).toExternalForm();
            }
        });
        aRegistry.registerTypeConverter(URL.class, File.class, new ITypeConverter(){

            @Override
            public File convert(@Nonnull Object aSource) {
                URL aURL = (URL)aSource;
                try {
                    return new File(aURL.toURI().getSchemeSpecificPart());
                }
                catch (URISyntaxException ex) {
                    return new File(aURL.getPath());
                }
            }
        });
        aRegistry.registerTypeConverter(URL.class, URI.class, new ITypeConverter(){

            @Override
            public URI convert(@Nonnull Object aSource) {
                try {
                    return ((URL)aSource).toURI();
                }
                catch (URISyntaxException ex) {
                    return null;
                }
            }
        });
        aRegistry.registerTypeConverter(String.class, File.class, new ITypeConverter(){

            @Override
            public File convert(@Nonnull Object aSource) {
                return new File((String)aSource);
            }
        });
        aRegistry.registerTypeConverter(String.class, URI.class, new ITypeConverter(){

            @Override
            public URI convert(@Nonnull Object aSource) {
                try {
                    return new URI((String)aSource);
                }
                catch (URISyntaxException ex) {
                    return null;
                }
            }
        });
        aRegistry.registerTypeConverter(String.class, URL.class, new ITypeConverter(){

            @Override
            public URL convert(@Nonnull Object aSource) {
                try {
                    return new URL((String)aSource);
                }
                catch (MalformedURLException ex) {
                    return null;
                }
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(IResourceBase.class, String.class){

            @Override
            public String convert(@Nonnull Object aSource) {
                return ((IResourceBase)aSource).getPath();
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(IResourceBase.class, URL.class){

            @Override
            public URL convert(@Nonnull Object aSource) {
                return ((IResourceBase)aSource).getAsURL();
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(IResourceBase.class, File.class){

            @Override
            public File convert(@Nonnull Object aSource) {
                return ((IResourceBase)aSource).getAsFile();
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(IInputStreamProvider.class, InputStream.class){

            @Override
            public InputStream convert(@Nonnull Object aSource) {
                return ((IInputStreamProvider)aSource).getInputStream();
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(IOutputStreamProvider.class, OutputStream.class){

            @Override
            public OutputStream convert(@Nonnull Object aSource) {
                return ((IOutputStreamProvider)aSource).getOutputStream(EAppend.DEFAULT);
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(IReaderProvider.class, Reader.class){

            @Override
            public Reader convert(@Nonnull Object aSource) {
                return ((IReaderProvider)aSource).getReader();
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(IWriterProvider.class, Writer.class){

            @Override
            public Writer convert(@Nonnull Object aSource) {
                return ((IWriterProvider)aSource).getWriter();
            }
        });
        aRegistry.registerTypeConverter(String.class, ClassPathResource.class, new ITypeConverter(){

            @Override
            public ClassPathResource convert(@Nonnull Object aSource) {
                return new ClassPathResource((String)aSource);
            }
        });
        aRegistry.registerTypeConverter(URL.class, ClassPathResource.class, new ITypeConverter(){

            @Override
            public ClassPathResource convert(@Nonnull Object aSource) {
                return new ClassPathResource((URL)aSource);
            }
        });
        aRegistry.registerTypeConverter(String.class, FileSystemResource.class, new ITypeConverter(){

            @Override
            public FileSystemResource convert(@Nonnull Object aSource) {
                return new FileSystemResource((String)aSource);
            }
        });
        aRegistry.registerTypeConverter(URL.class, FileSystemResource.class, new ITypeConverter(){

            @Override
            public FileSystemResource convert(@Nonnull Object aSource) {
                try {
                    URI aURI = ((URL)aSource).toURI();
                    return new FileSystemResource(aURI);
                }
                catch (IllegalArgumentException e) {
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                return null;
            }
        });
        aRegistry.registerTypeConverter(String.class, URLResource.class, new ITypeConverter(){

            @Override
            public URLResource convert(@Nonnull Object aSource) {
                try {
                    return new URLResource((String)aSource);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        });
        aRegistry.registerTypeConverter(URL.class, URLResource.class, new ITypeConverter(){

            @Override
            public URLResource convert(@Nonnull Object aSource) {
                return new URLResource((URL)aSource);
            }
        });
        aRegistry.registerTypeConverter(URI.class, URLResource.class, new ITypeConverter(){

            @Override
            public URLResource convert(@Nonnull Object aSource) {
                try {
                    return new URLResource(((URI)aSource).toURL());
                }
                catch (MalformedURLException ex) {
                    return null;
                }
            }
        });
    }
}

