/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.url;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.annotations.ReturnsMutableObject;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.url.IURLData;
import com.phloc.commons.url.IURLProtocol;
import com.phloc.commons.url.URLProtocolRegistry;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class URLData
implements IURLData {
    private final String m_sPath;
    private final Map<String, String> m_aParams;
    private final String m_sAnchor;

    public URLData(@Nonnull String sPath) {
        this(sPath, null, null);
    }

    public URLData(@Nonnull String sPath, @Nullable Map<String, String> aParams) {
        this(sPath, aParams, null);
    }

    public URLData(@Nonnull String sPath, @Nullable Map<String, String> aParams, @Nullable String sAnchor) {
        if (sPath == null) {
            throw new NullPointerException("href may not be null");
        }
        this.m_sPath = sPath;
        this.m_aParams = aParams;
        this.m_sAnchor = sAnchor;
    }

    @Override
    @Nullable
    public IURLProtocol getProtocol() {
        return URLProtocolRegistry.getProtocol(this.m_sPath);
    }

    @Override
    public boolean hasKnownProtocol() {
        return URLProtocolRegistry.hasKnownProtocol(this.m_sPath);
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.m_sPath;
    }

    @Override
    public boolean hasParams() {
        return !ContainerHelper.isEmpty(this.m_aParams);
    }

    @Override
    @Nonnegative
    public int getParamCount() {
        return ContainerHelper.getSize(this.m_aParams);
    }

    @Override
    @Nullable
    @ReturnsMutableObject(reason="Performance reasons")
    public Map<String, String> directGetParams() {
        return this.m_aParams;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllParams() {
        return ContainerHelper.newOrderedMap(this.m_aParams);
    }

    @Override
    public boolean hasAnchor() {
        return StringHelper.hasText(this.m_sAnchor);
    }

    @Override
    @Nullable
    public String getAnchor() {
        return this.m_sAnchor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof URLData)) {
            return false;
        }
        URLData rhs = (URLData)o;
        return this.m_sPath.equals(rhs.m_sPath) && EqualsUtils.equals(this.m_aParams, rhs.m_aParams) && EqualsUtils.equals(this.m_sAnchor, rhs.m_sAnchor);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sPath).append((Map)this.m_aParams)).append(this.m_sAnchor).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("path", this.m_sPath).appendIfNotNull("params", this.m_aParams).appendIfNotNull("anchor", this.m_sAnchor).toString();
    }
}

