/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.url;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.lang.ServiceLoaderBackport;
import com.phloc.commons.url.EURLProtocol;
import com.phloc.commons.url.IURLData;
import com.phloc.commons.url.IURLProtocol;
import com.phloc.commons.url.IURLProtocolRegistrarSPI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class URLProtocolRegistry {
    private static final Logger s_aLogger = LoggerFactory.getLogger(URLProtocolRegistry.class);
    private static final ReentrantReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<String, IURLProtocol> s_aProtocols = new HashMap<String, IURLProtocol>();

    private URLProtocolRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reinitialize() {
        s_aRWLock.writeLock().lock();
        try {
            s_aProtocols.clear();
            for (EURLProtocol aProtocol : EURLProtocol.values()) {
                s_aProtocols.put(aProtocol.getProtocol(), aProtocol);
            }
            for (IURLProtocolRegistrarSPI aRegistrar : ServiceLoaderBackport.load(IURLProtocolRegistrarSPI.class)) {
                s_aLogger.info("Registering custom URL protocols of " + aRegistrar.getClass().getCanonicalName() + "...");
                Set<? extends IURLProtocol> aURLProtocols = aRegistrar.getProtocols();
                if (aURLProtocols == null) continue;
                for (IURLProtocol iURLProtocol : aURLProtocols) {
                    URLProtocolRegistry.registerProtocol(iURLProtocol);
                }
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProtocol(@Nonnull IURLProtocol aProtocol) {
        if (aProtocol == null) {
            throw new NullPointerException("protocol");
        }
        s_aRWLock.writeLock().lock();
        try {
            String sProtocol = aProtocol.getProtocol();
            if (s_aProtocols.containsKey(sProtocol)) {
                throw new IllegalArgumentException("Another handler for protocol '" + sProtocol + "' is already registered!");
            }
            s_aProtocols.put(sProtocol, aProtocol);
            s_aLogger.info("Registered new custom URL protocol: " + aProtocol);
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Collection<IURLProtocol> getAllProtocols() {
        s_aRWLock.readLock().lock();
        try {
            List<IURLProtocol> list = ContainerHelper.newList(s_aProtocols.values());
            return list;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IURLProtocol getProtocol(@Nullable String sURL) {
        if (sURL != null) {
            s_aRWLock.readLock().lock();
            try {
                for (IURLProtocol aProtocol : s_aProtocols.values()) {
                    if (!aProtocol.isUsedInURL(sURL)) continue;
                    IURLProtocol iURLProtocol = aProtocol;
                    return iURLProtocol;
                }
            }
            finally {
                s_aRWLock.readLock().unlock();
            }
        }
        return null;
    }

    @Nullable
    public static IURLProtocol getProtocol(@Nullable IURLData aURL) {
        return aURL == null ? null : URLProtocolRegistry.getProtocol(aURL.getPath());
    }

    public static boolean hasKnownProtocol(@Nullable String sURL) {
        return URLProtocolRegistry.getProtocol(sURL) != null;
    }

    public static boolean hasKnownProtocol(@Nullable IURLData aURL) {
        return URLProtocolRegistry.getProtocol(aURL) != null;
    }

    @Nullable
    public static String getWithoutProtocol(@Nullable String sURL) {
        IURLProtocol aProtocol = URLProtocolRegistry.getProtocol(sURL);
        return aProtocol == null ? sURL : sURL.substring(aProtocol.getProtocol().length());
    }

    static {
        URLProtocolRegistry.reinitialize();
    }
}

