/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EXMLVersion {
    XML_10("1.0"),
    XML_11("1.1");

    public static final EXMLVersion DEFAULT;
    private final String m_sVersion;

    private EXMLVersion(String sVersion) {
        this.m_sVersion = sVersion;
    }

    @Nonnull
    @Nonempty
    public String getVersion() {
        return this.m_sVersion;
    }

    @Nullable
    public static EXMLVersion getFromVersionOrNull(@Nullable String sVersion) {
        return EXMLVersion.getFromVersionOrDefault(sVersion, null);
    }

    @Nullable
    public static EXMLVersion getFromVersionOrDefault(@Nullable String sVersion, @Nullable EXMLVersion eDefault) {
        if (StringHelper.hasText(sVersion)) {
            for (EXMLVersion eVersion : EXMLVersion.values()) {
                if (!eVersion.getVersion().equals(sVersion)) continue;
                return eVersion;
            }
        }
        return eDefault;
    }

    static {
        DEFAULT = XML_10;
    }
}

