/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RecursiveChildNodeIterator
implements IIterableIterator<Node> {
    private final Iterator<Node> m_aIter;

    public RecursiveChildNodeIterator(@Nonnull Node eParent) {
        if (eParent == null) {
            throw new NullPointerException("parent");
        }
        ArrayList<Node> aNodes = new ArrayList<Node>();
        RecursiveChildNodeIterator._fillListPrefix(eParent, aNodes);
        this.m_aIter = aNodes.iterator();
    }

    private static void _fillListPrefix(@Nonnull Node aParent, @Nonnull List<Node> aNodes) {
        NodeList aNodeList = aParent.getChildNodes();
        if (aNodeList != null) {
            int nlsize = aNodeList.getLength();
            for (int i = 0; i < nlsize; ++i) {
                Node aCurrent = aNodeList.item(i);
                aNodes.add(aCurrent);
                RecursiveChildNodeIterator._fillListPrefix(aCurrent, aNodes);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.m_aIter.hasNext();
    }

    @Override
    public Node next() {
        return this.m_aIter.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Iterator<Node> iterator() {
        return this;
    }

    public String toString() {
        return new ToStringGenerator(this).append("iter", this.m_aIter).toString();
    }
}

