/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.sax;

import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.io.streams.StreamUtils;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.xml.sax.InputSource;

@NotThreadSafe
public final class CachingSAXInputSource
extends InputSource {
    @Nonnull
    private static NonBlockingByteArrayInputStream _getCachedInputStream(@Nonnull @WillClose InputStream aIS) {
        return new NonBlockingByteArrayInputStream(StreamUtils.getAllBytes(aIS));
    }

    public CachingSAXInputSource(@Nonnull IReadableResource aRes) {
        this(aRes.getInputStream(), aRes.getResourceID());
    }

    public CachingSAXInputSource(@Nonnull IInputStreamProvider aISP) {
        this(aISP.getInputStream(), null);
    }

    public CachingSAXInputSource(@Nonnull IInputStreamProvider aISP, @Nullable String sSystemID) {
        this(aISP.getInputStream(), sSystemID);
    }

    public CachingSAXInputSource(@Nonnull @WillClose InputStream aIS) {
        this(aIS, null);
    }

    public CachingSAXInputSource(@Nonnull @WillClose InputStream aIS, @Nullable String sSystemID) {
        super(CachingSAXInputSource._getCachedInputStream(aIS));
        this.setSystemId(sSystemID);
    }
}

