/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.sax;

import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.resource.FileSystemResource;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.xml.sax.ReadableResourceSAXInputSource;
import com.phloc.commons.xml.sax.StringSAXInputSource;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.xml.sax.InputSource;

@Immutable
public final class InputSourceFactory {
    private InputSourceFactory() {
    }

    @Nonnull
    public static InputSource create(@Nonnull File aFile) {
        return InputSourceFactory.create(new FileSystemResource(aFile));
    }

    @Nonnull
    public static InputSource create(@Nonnull URL aURL) {
        return InputSourceFactory.create(new URLResource(aURL));
    }

    @Nonnull
    public static InputSource create(@Nonnull IInputStreamProvider aISP) {
        if (aISP instanceof IReadableResource) {
            return InputSourceFactory.create((IReadableResource)aISP);
        }
        return InputSourceFactory.create(aISP.getInputStream());
    }

    @Nonnull
    public static InputSource create(@Nonnull IReadableResource aResource) {
        return new ReadableResourceSAXInputSource(aResource);
    }

    @Nonnull
    public static InputSource create(@Nonnull String sXML) {
        return new StringSAXInputSource(sXML);
    }

    @Nonnull
    public static InputSource create(@Nonnull char[] aXML) {
        return InputSourceFactory.create(new String(aXML));
    }

    @Nonnull
    public static InputSource create(@Nonnull char[] aXML, @Nonnegative int nOfs, @Nonnegative int nLength) {
        return InputSourceFactory.create(new String(aXML, nOfs, nLength));
    }

    @Nonnull
    public static InputSource create(@Nonnull byte[] aXML) {
        return InputSourceFactory.create(new NonBlockingByteArrayInputStream(aXML));
    }

    @Nonnull
    public static InputSource create(@Nonnull byte[] aXML, @Nonnegative int nOfs, @Nonnegative int nLength) {
        return InputSourceFactory.create(new NonBlockingByteArrayInputStream(aXML, nOfs, nLength));
    }

    @Nonnull
    public static InputSource create(@Nonnull CharSequence aXML) {
        if (aXML instanceof String) {
            return InputSourceFactory.create((String)aXML);
        }
        return InputSourceFactory.create(((Object)aXML).toString());
    }

    @Nonnull
    public static InputSource create(@Nullable InputStream aIS) {
        return new InputSource(aIS);
    }

    @Nonnull
    public static InputSource create(@Nullable Reader aReader) {
        return new InputSource(aReader);
    }
}

