/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.CGlobal;
import com.phloc.commons.microdom.IMicroDocumentType;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.DefaultXMLIterationHandler;
import com.phloc.commons.xml.EXMLIncorrectCharacterHandling;
import com.phloc.commons.xml.EXMLVersion;
import com.phloc.commons.xml.XMLHelper;
import com.phloc.commons.xml.serialize.IXMLWriterSettings;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class XMLEmitterPhloc
extends DefaultXMLIterationHandler {
    public static final boolean DEFAULT_THROW_EXCEPTION_ON_NESTED_COMMENTS = true;
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String COMMENT_START = "<!--";
    private static final String COMMENT_END = "-->";
    private static final char ER_START = '&';
    private static final char ER_END = ';';
    private static final String PI_START = "<?";
    private static final String PI_END = "?>";
    private static final String CRLF = CGlobal.LINE_SEPARATOR;
    private static boolean s_bThrowExceptionOnNestedComments = true;
    private final Writer m_aWriter;
    private final IXMLWriterSettings m_aSettings;
    private EXMLVersion m_eXMLVersion = EXMLVersion.DEFAULT;
    private final char m_cTextBoundary;

    public XMLEmitterPhloc(@Nonnull @WillNotClose Writer aWriter, @Nonnull IXMLWriterSettings aSettings) {
        if (aWriter == null) {
            throw new NullPointerException("writer");
        }
        if (aSettings == null) {
            throw new NullPointerException("settings");
        }
        this.m_aWriter = aWriter;
        this.m_aSettings = aSettings;
        this.m_cTextBoundary = (char)(aSettings.isUseDoubleQuotesForAttributes() ? 34 : 39);
    }

    public static void setThrowExceptionOnNestedComments(boolean bThrowExceptionOnNestedComments) {
        s_bThrowExceptionOnNestedComments = bThrowExceptionOnNestedComments;
    }

    public static boolean isThrowExceptionOnNestedComments() {
        return s_bThrowExceptionOnNestedComments;
    }

    @Nonnull
    private XMLEmitterPhloc _append(@Nonnull String aValue) {
        try {
            this.m_aWriter.write(aValue);
            return this;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Nonnull
    private XMLEmitterPhloc _append(char aValue) {
        try {
            this.m_aWriter.write(aValue);
            return this;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Nonnull
    private XMLEmitterPhloc _appendMasked(@Nullable String sValue) {
        try {
            XMLHelper.maskXMLTextTo(this.m_eXMLVersion, this.m_aSettings.getIncorrectCharacterHandling(), sValue, this.m_aWriter);
            return this;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Nonnull
    private XMLEmitterPhloc _appendAttr(@Nullable String sValue) {
        return this._append(this.m_cTextBoundary)._appendMasked(sValue)._append(this.m_cTextBoundary);
    }

    @Override
    public void onDocumentStart(@Nullable EXMLVersion eVersion, @Nullable String sEncoding, boolean bStandalone) {
        if (eVersion != null) {
            this.m_eXMLVersion = eVersion;
        }
        this._append(PI_START)._append("xml version=")._appendAttr(this.m_eXMLVersion.getVersion());
        if (sEncoding != null) {
            this._append(" encoding=")._appendAttr(sEncoding);
        }
        if (bStandalone) {
            this._append(" standalone=")._appendAttr("yes");
        }
        this._append(PI_END)._append(CRLF);
    }

    @Nonnull
    public static String getDocTypeHTMLRepresentation(@Nonnull EXMLVersion eXMLVersion, @Nonnull EXMLIncorrectCharacterHandling eIncorrectCharHandling, @Nonnull IMicroDocumentType aDocType) {
        return XMLEmitterPhloc.getDocTypeHTMLRepresentation(eXMLVersion, eIncorrectCharHandling, aDocType.getQualifiedName(), aDocType.getPublicID(), aDocType.getSystemID());
    }

    @Nonnull
    public static String getDocTypeHTMLRepresentation(@Nonnull EXMLVersion eXMLVersion, @Nonnull EXMLIncorrectCharacterHandling eIncorrectCharHandling, @Nonnull String sQualifiedName, @Nullable String sPublicID, @Nullable String sSystemID) {
        StringBuilder aSB = new StringBuilder(128);
        aSB.append("<!DOCTYPE ").append(sQualifiedName);
        if (sPublicID != null && sSystemID != null) {
            aSB.append(" PUBLIC \"").append(XMLHelper.getMaskedXMLText(eXMLVersion, eIncorrectCharHandling, sPublicID)).append("\" \"").append(XMLHelper.getMaskedXMLText(eXMLVersion, eIncorrectCharHandling, sSystemID)).append('\"');
        } else if (sSystemID != null) {
            aSB.append(" SYSTEM \"").append(XMLHelper.getMaskedXMLText(eXMLVersion, eIncorrectCharHandling, sSystemID)).append('\"');
        }
        return aSB.append('>').append(CRLF).toString();
    }

    @Override
    public void onDocumentType(@Nonnull String sQualifiedElementName, @Nullable String sPublicID, @Nullable String sSystemID) {
        if (sQualifiedElementName == null) {
            throw new NullPointerException("qualifiedElementName");
        }
        String sDocType = XMLEmitterPhloc.getDocTypeHTMLRepresentation(this.m_eXMLVersion, this.m_aSettings.getIncorrectCharacterHandling(), sQualifiedElementName, sPublicID, sSystemID);
        this._append(sDocType);
    }

    @Override
    public void onProcessingInstruction(@Nonnull String sTarget, @Nullable String sData) {
        this._append(PI_START)._append(sTarget);
        if (StringHelper.hasText(sData)) {
            this._append(' ')._append(sData);
        }
        this._append(PI_END)._append(CRLF);
    }

    @Override
    public void onEntityReference(@Nonnull String sEntityRef) {
        this._append('&')._append(sEntityRef)._append(';');
    }

    @Override
    public void onContentElementWhitespace(@Nullable CharSequence aWhitespaces) {
        if (StringHelper.hasText(aWhitespaces)) {
            this._append(((Object)aWhitespaces).toString());
        }
    }

    @Override
    public void onComment(@Nullable String sComment) {
        if (StringHelper.hasText(sComment)) {
            if (XMLEmitterPhloc.isThrowExceptionOnNestedComments() && (sComment.contains(COMMENT_START) || sComment.contains(COMMENT_END))) {
                throw new IllegalArgumentException("XML comment contains nested XML comment: " + sComment);
            }
            this._append(COMMENT_START)._append(sComment)._append(COMMENT_END);
        }
    }

    @Override
    public void onText(@Nullable String sText, boolean bEscape) {
        if (bEscape) {
            this._appendMasked(sText);
        } else {
            this._append(sText);
        }
    }

    @Override
    public void onCDATA(@Nullable String sText) {
        if (StringHelper.hasText(sText)) {
            List<String> aParts = StringHelper.getExploded(CDATA_END, sText);
            int nParts = aParts.size();
            for (int i = 0; i < nParts; ++i) {
                this._append(CDATA_START)._append(aParts.get(i))._append(CDATA_END);
                if (i >= nParts - 1) continue;
                this._appendMasked(CDATA_END);
            }
        }
    }

    @Override
    public void onElementStart(@Nullable String sNamespacePrefix, @Nonnull String sTagName, @Nullable Map<String, String> aAttrs, boolean bHasChildren) {
        this._append('<');
        if (StringHelper.hasText(sNamespacePrefix)) {
            this._append(sNamespacePrefix)._append(':');
        }
        this._append(sTagName);
        if (aAttrs != null && !aAttrs.isEmpty()) {
            for (Map.Entry<String, String> aEntry : aAttrs.entrySet()) {
                String sAttrName = aEntry.getKey();
                String sAttrValue = aEntry.getValue();
                this._append(' ')._append(sAttrName)._append('=')._appendAttr(sAttrValue);
            }
        }
        this._append(bHasChildren ? ">" : (this.m_aSettings.isSpaceOnSelfClosedElement() ? " />" : "/>"));
    }

    @Override
    public void onElementEnd(@Nullable String sNamespacePrefix, @Nonnull String sTagName) {
        this._append("</");
        if (StringHelper.hasText(sNamespacePrefix)) {
            this._append(sNamespacePrefix)._append(':');
        }
        this._append(sTagName)._append('>');
    }

    public String toString() {
        return new ToStringGenerator(this).append("writer", this.m_aWriter).append("settings", this.m_aSettings).append("version", this.m_eXMLVersion).toString();
    }
}

