/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.transform;

import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.xml.transform.ResourceStreamSource;
import com.phloc.commons.xml.transform.StringStreamSource;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

@Immutable
public final class TransformSourceFactory {
    private TransformSourceFactory() {
    }

    @Nonnull
    public static StreamSource create(@Nonnull File aFile) {
        return new StreamSource(aFile);
    }

    @Nonnull
    public static ResourceStreamSource create(@Nonnull URL aURL) {
        return TransformSourceFactory.create(new URLResource(aURL));
    }

    @Nonnull
    public static StreamSource create(@Nonnull IInputStreamProvider aISP) {
        if (aISP instanceof IReadableResource) {
            return TransformSourceFactory.create((IReadableResource)aISP);
        }
        return TransformSourceFactory.create(aISP.getInputStream());
    }

    @Nonnull
    public static ResourceStreamSource create(@Nonnull IReadableResource aResource) {
        return new ResourceStreamSource(aResource);
    }

    @Nonnull
    public static StringStreamSource create(@Nonnull String sXML) {
        return new StringStreamSource(sXML);
    }

    @Nonnull
    public static StringStreamSource create(@Nonnull char[] aXML) {
        return TransformSourceFactory.create(new String(aXML));
    }

    @Nonnull
    public static StringStreamSource create(@Nonnull char[] aXML, @Nonnegative int nOfs, @Nonnegative int nLength) {
        return TransformSourceFactory.create(new String(aXML, nOfs, nLength));
    }

    @Nonnull
    public static StreamSource create(@Nonnull byte[] aXML) {
        return TransformSourceFactory.create(new NonBlockingByteArrayInputStream(aXML));
    }

    @Nonnull
    public static StreamSource create(@Nonnull byte[] aXML, @Nonnegative int nOfs, @Nonnegative int nLength) {
        return TransformSourceFactory.create(new NonBlockingByteArrayInputStream(aXML, nOfs, nLength));
    }

    @Nonnull
    public static StringStreamSource create(@Nonnull CharSequence aXML) {
        if (aXML instanceof String) {
            return TransformSourceFactory.create((String)aXML);
        }
        return TransformSourceFactory.create(((Object)aXML).toString());
    }

    @Nonnull
    public static StreamSource create(@Nullable InputStream aIS) {
        return new StreamSource(aIS);
    }

    @Nonnull
    public static StreamSource create(@Nullable Reader aReader) {
        return new StreamSource(aReader);
    }

    @Nonnull
    public static DOMSource create(@Nullable Node aNode) {
        return new DOMSource(aNode);
    }
}

