/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.handler;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.css.ECSSVersion;
import com.phloc.css.parser.CSSNode;
import com.phloc.css.parser.ParserCSS21TreeConstants;
import com.phloc.css.parser.ParserCSS30TreeConstants;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ECSSNodeType {
    ROOT(1, 1),
    CHARSET(2, 2),
    UNKNOWNRULE(3, 3),
    STYLERULE(14, 34),
    IMPORTRULE(4, 4),
    PAGERULE(9, 13),
    MEDIARULE(5, 5),
    FONTFACERULE(-1, 15),
    SELECTOR(15, 20),
    STYLEDECLARATION(23, 37),
    DECLARATION(24, 36),
    NAMESPACEPREFIX(-1, 22),
    UNIVERSAL(-1, 24),
    ELEMENTNAME(17, 23),
    HASH(22, 35),
    CLASS(16, 25),
    PSEUDO(21, 29),
    NEGATION(-1, 31),
    ATTRIB(18, 26),
    ATTRIBOPERATOR(19, 27),
    ATTRIBVALUE(20, 28),
    COMBINATOR(12, 21),
    NTH(-1, 30),
    PROPERTY(13, 33),
    IMPORTANT(25, 38),
    EXPR(26, 39),
    TERM(27, 40),
    OPERATOR(11, 32),
    URI(28, 41),
    FUNCTION(29, 42),
    MATH(-1, 43),
    MATH_SUMOPERATOR(-1, 44),
    MATH_PRODUCT(-1, 46),
    MATH_PRODUCTOPERATOR(-1, 45),
    MATH_UNIT(-1, 47),
    MEDIALIST(6, 6),
    MEDIUM(8, 10),
    MEDIAQUERY(-1, 8),
    MEDIAMODIFIER(-1, 9),
    MEDIAEXPR(-1, 11),
    MEDIAFEATURE(-1, 12),
    PSEUDOPAGE(10, 14),
    KEYFRAMESRULE(-1, 16),
    KEYFRAMESIDENTIFIER(-1, 17),
    KEYFRAMESSELECTOR(-1, 18),
    SINGLEKEYFRAMESELECTOR(-1, 19),
    ERROR_SKIPTO(0, 0);

    private static final Logger s_aLogger;
    private final int m_nParserType21;
    private final int m_nParserType30;

    private ECSSNodeType(int nParserType21, int nParserType30) {
        this.m_nParserType21 = nParserType21;
        this.m_nParserType30 = nParserType30;
    }

    int getParserNodeType(@Nonnull ECSSVersion eVersion) {
        switch (eVersion) {
            case CSS21: {
                return this.m_nParserType21;
            }
            case CSS30: {
                return this.m_nParserType30;
            }
        }
        throw new IllegalStateException("Illegal version provided: " + (Object)((Object)eVersion));
    }

    public boolean isNode(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion) {
        return aParserNode.getNodeType() == this.getParserNodeType(eVersion);
    }

    @Nonnull
    String getNodeName(@Nonnull ECSSVersion eVersion) {
        switch (eVersion) {
            case CSS21: {
                return this.m_nParserType21 == -1 ? this.name() : ParserCSS21TreeConstants.jjtNodeName[this.m_nParserType21];
            }
            case CSS30: {
                return ParserCSS30TreeConstants.jjtNodeName[this.m_nParserType30];
            }
        }
        throw new IllegalStateException("Illegal version provided: " + (Object)((Object)eVersion));
    }

    @Nullable
    static ECSSNodeType getNodeType(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion) {
        for (ECSSNodeType eNodeType : ECSSNodeType.values()) {
            if (!eNodeType.isNode(aParserNode, eVersion)) continue;
            return eNodeType;
        }
        return null;
    }

    @Nullable
    static String getNodeName(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion) {
        ECSSNodeType eNodeType = ECSSNodeType.getNodeType(aParserNode, eVersion);
        if (eNodeType != null) {
            return eNodeType.getNodeName(eVersion);
        }
        s_aLogger.warn("Unsupported node type " + aParserNode.getNodeType() + " in version " + (Object)((Object)eVersion));
        return null;
    }

    private static void _dumpRecursive(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion, @Nonnull StringBuilder aSB, @Nonnull String sPrefix) {
        aSB.append(sPrefix).append(ECSSNodeType.getNodeName(aParserNode, eVersion));
        if (aParserNode.hasText()) {
            aSB.append('[').append(aParserNode.getText()).append(']');
        }
        aSB.append('\n');
        for (CSSNode aChildNode : aParserNode) {
            ECSSNodeType._dumpRecursive(aChildNode, eVersion, aSB, sPrefix + "  ");
        }
    }

    @Nonnull
    @Nonempty
    static String getDump(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion) {
        StringBuilder aSB = new StringBuilder();
        ECSSNodeType._dumpRecursive(aParserNode, eVersion, aSB, "");
        return aSB.toString();
    }

    static {
        s_aLogger = LoggerFactory.getLogger(ECSSNodeType.class);
    }
}

