/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.utils;

import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.StringParser;
import com.phloc.css.ECSSUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSNumberHelper {
    private CSSNumberHelper() {
    }

    @Nullable
    public static ECSSUnit getMatchingUnitInclPercentage(@Nonnull String sCSSValue) {
        for (ECSSUnit eUnit : ECSSUnit.values()) {
            if (!sCSSValue.endsWith(eUnit.getName())) continue;
            return eUnit;
        }
        return null;
    }

    @Nullable
    public static ECSSUnit getMatchingUnitExclPercentage(@Nonnull String sCSSValue) {
        for (ECSSUnit eUnit : ECSSUnit.values()) {
            if (eUnit == ECSSUnit.PERCENTAGE || !sCSSValue.endsWith(eUnit.getName())) continue;
            return eUnit;
        }
        return null;
    }

    public static boolean isNumberValue(@Nullable String sCSSValue) {
        String sRealValue = StringHelper.trim((String)sCSSValue);
        return StringHelper.hasText((CharSequence)sRealValue) && StringParser.isDouble((String)sRealValue);
    }

    public static boolean isNumberWithUnitValue(@Nullable String sCSSValue, boolean bWithPerc) {
        String sRealValue = StringHelper.trim((String)sCSSValue);
        if (StringHelper.hasText((CharSequence)sRealValue)) {
            ECSSUnit eUnit;
            ECSSUnit eCSSUnit = eUnit = bWithPerc ? CSSNumberHelper.getMatchingUnitInclPercentage(sRealValue) : CSSNumberHelper.getMatchingUnitExclPercentage(sRealValue);
            if (eUnit != null) {
                sRealValue = sRealValue.substring(0, sRealValue.length() - eUnit.getName().length()).trim();
            }
            return CSSNumberHelper.isNumberValue(sRealValue);
        }
        return false;
    }
}

